/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.util;

import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.reflect.Fields;
import cn.ponfee.commons.util.ObjectUtils;
import cn.ponfee.commons.util.Strings;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;

public final class PropertiesUtils {
    public static Properties filterProperties(Properties props, String keyPrefix) {
        Properties properties = new Properties();
        int prefixLen = keyPrefix.length();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            if (key.startsWith(keyPrefix)) {
                properties.put(key.substring(prefixLen), v);
            }
        }));
        return properties;
    }

    public static <T> T extract(Properties props, Class<T> beanType, String prefix, char ... separators) {
        T bean = ClassUtils.newInstance(beanType);
        List<Field> fields = Objects.requireNonNull(ClassUtils.listFields(beanType));
        block0: for (Field field : fields) {
            for (char separator : separators) {
                String name = prefix + Strings.toSeparatedName(field.getName(), separator);
                if (!props.containsKey(name)) continue;
                Fields.put(bean, field, ObjectUtils.cast(props.get(name), field.getType()));
                continue block0;
            }
        }
        return bean;
    }
}

