/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.util;

import cn.ponfee.commons.util.Strings;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class SqlUtils {
    private static final Pattern LIMIT_MYSQL = Pattern.compile("^(.+)(\\s+(?i)LIMIT\\s+(\\d+)(\\s*,\\s*(\\d+))?\\s*)$");
    private static final Pattern LIMIT_PGSQL = Pattern.compile("^(.+)(?i)(\\s+LIMIT\\s+(\\d+)(\\s+OFFSET\\s+(\\d+))?\\s*)$");
    private static final Pattern LIMIT_ORACLE = Pattern.compile("^(.+)(\\s+(?i)ROWNUM\\s*<=?\\s*(\\d+))(\\s+(?i)AND\\s+.+|\\s*)$");
    private static final Pattern LIMIT_SQLSERVER = Pattern.compile("^(.+?)(\\s+(?i)TOP\\s+(\\d+)\\s+)(.+)$");
    private static final Pattern SELECT_SQLSERVER = Pattern.compile("^(\\s*(?i)SELECT\\s)(.+)$");
    private static final Pattern LIMIT_HIVE = Pattern.compile("^(.+)(\\s+(?i)LIMIT\\s+(\\d+)?\\s*)$");

    public static String trim(String sql) {
        int start;
        int end;
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return sql;
        }
        int n = end = sql.length() - 1;
        for (start = 0; start < n && SqlUtils.isBlank(sql.charAt(start)); ++start) {
        }
        if (start == n) {
            return "";
        }
        while (end > start && SqlUtils.isBlankOrSemicolon(sql.charAt(end))) {
            --end;
        }
        return start == end ? "" : sql.substring(start, end + 1);
    }

    public static String limitMysql(String sql, int limit) {
        String outermostSql = SqlUtils.outermostSql(sql);
        Matcher matcher = LIMIT_MYSQL.matcher(outermostSql);
        if (!matcher.matches()) {
            return sql + " LIMIT " + limit;
        }
        String a = matcher.group(3);
        String b = matcher.group(5);
        if (Integer.parseInt(Optional.ofNullable(b).orElse(a)) <= limit) {
            return sql;
        }
        String replace = b == null ? Integer.toString(limit) : a + "," + limit;
        return sql.substring(0, sql.length() - outermostSql.length()) + matcher.group(1) + " LIMIT " + replace;
    }

    public static String limitPgsql(String sql, int limit) {
        String outermostSql = SqlUtils.outermostSql(sql);
        Matcher matcher = LIMIT_PGSQL.matcher(outermostSql);
        if (!matcher.matches()) {
            return sql + " LIMIT " + limit;
        }
        String a = matcher.group(3);
        String b = matcher.group(5);
        if (Integer.parseInt(a) <= limit) {
            return sql;
        }
        String limitStr = limit + (b == null ? "" : " OFFSET " + b);
        return sql.substring(0, sql.length() - outermostSql.length()) + matcher.group(1) + " LIMIT " + limitStr;
    }

    public static String limitOracle(String sql, int limit) {
        String outermostSql = SqlUtils.outermostSql(sql);
        Matcher matcher = LIMIT_ORACLE.matcher(outermostSql);
        if (!matcher.matches()) {
            return sql + SqlUtils.completeWhere(outermostSql) + " ROWNUM<" + limit;
        }
        String a = matcher.group(3);
        if (Integer.parseInt(a) <= limit) {
            return sql;
        }
        String mid = matcher.group(1);
        String tail = matcher.group(4);
        return sql.substring(0, sql.length() - outermostSql.length()) + mid + SqlUtils.completeWhere(mid) + " ROWNUM<" + limit + Strings.ifEmpty(tail, "");
    }

    public static String limitMssql(String sql, int limit) {
        Matcher matcher = LIMIT_SQLSERVER.matcher(sql);
        if (!matcher.matches()) {
            matcher = SELECT_SQLSERVER.matcher(sql);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid select sql: " + sql);
            }
            return matcher.group(1) + "TOP " + limit + " " + matcher.group(2);
        }
        String top = matcher.group(3);
        if (Integer.parseInt(top) <= limit) {
            return sql;
        }
        return matcher.group(1) + " TOP " + limit + " " + matcher.group(4);
    }

    public static String limitHive(String sql, int limit) {
        String outermostSql = SqlUtils.outermostSql(sql);
        Matcher matcher = LIMIT_HIVE.matcher(outermostSql);
        if (!matcher.matches()) {
            return sql + " LIMIT " + limit;
        }
        String a = matcher.group(3);
        if (Integer.parseInt(a) <= limit) {
            return sql;
        }
        return sql.substring(0, sql.length() - outermostSql.length()) + matcher.group(1) + " LIMIT " + limit;
    }

    private static boolean isBlank(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    private static boolean isBlankOrSemicolon(char ch) {
        return SqlUtils.isBlank(ch) || ch == ';';
    }

    private static String outermostSql(String sql) {
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return "";
        }
        int pos = sql.lastIndexOf(41);
        return pos == -1 ? sql : sql.substring(pos);
    }

    private static String completeWhere(String outermost) {
        if ((outermost = outermost.trim().toUpperCase()).endsWith(" WHERE") || outermost.endsWith(" AND")) {
            return "";
        }
        return outermost.contains(" WHERE ") ? " AND " : " WHERE ";
    }
}

