/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.web;

import cn.ponfee.commons.exception.BaseUncheckedException;
import cn.ponfee.commons.exception.UnauthorizedException;
import cn.ponfee.commons.model.Result;
import cn.ponfee.commons.model.ResultCode;
import cn.ponfee.commons.web.WebUtils;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public abstract class AbstractWebExceptionHandler {
    public static final int UNAUTHORIZED = ResultCode.UNAUTHORIZED.getCode();
    public static final int BAD_REQUEST = ResultCode.BAD_REQUEST.getCode();
    public static final int NOT_ALLOWED = ResultCode.NOT_ALLOWED.getCode();
    public static final int UNSUPPORT_MEDIA = ResultCode.UNSUPPORT_MEDIA.getCode();
    public static final int SERVER_ERROR = ResultCode.SERVER_ERROR.getCode();
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractWebExceptionHandler.class);
    private final String unauthorizedPage;
    private final String serverErrorPage;
    private final String defaultErrorMsg;

    public AbstractWebExceptionHandler() {
        this("/page/401.html", "/page/500.html", "Server error.");
    }

    public AbstractWebExceptionHandler(String unauthorizedPage, String serverErrorPage, String defaultErrorMsg) {
        this.unauthorizedPage = unauthorizedPage;
        this.serverErrorPage = serverErrorPage;
        this.defaultErrorMsg = defaultErrorMsg;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public void handle(HttpServletRequest req, HttpServletResponse resp, UnauthorizedException e) {
        LOGGER.debug("Unauthorized", (Throwable)e);
        this.handle(req, resp, this.unauthorizedPage, e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public void handle(HttpServletRequest req, HttpServletResponse resp, BindException e) {
        LOGGER.debug("Bind failed", (Throwable)e);
        this.handle(req, resp, e.getAllErrors());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public void handleMethod(HttpServletRequest req, HttpServletResponse resp, MethodArgumentNotValidException e) {
        LOGGER.debug("Method argument not valid", (Throwable)e);
        this.handle(req, resp, e.getBindingResult().getAllErrors());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public void handle(HttpServletRequest req, HttpServletResponse resp, ConstraintViolationException e) {
        LOGGER.debug("Constraint violation", (Throwable)e);
        String message = e.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(",", "[", "]"));
        this.handle(req, resp, BAD_REQUEST, message);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, IllegalStateException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, ServletRequestBindingException.class})
    public void handle(HttpServletRequest req, HttpServletResponse resp, Exception e) {
        LOGGER.debug("Bad request", (Throwable)e);
        this.handle(req, resp, BAD_REQUEST, e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public void handle(HttpServletRequest req, HttpServletResponse resp, HttpRequestMethodNotSupportedException e) {
        LOGGER.debug("Request method not supported", (Throwable)e);
        this.handle(req, resp, NOT_ALLOWED, e.getMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public void handle(HttpServletRequest req, HttpServletResponse resp, HttpMediaTypeNotSupportedException e) {
        LOGGER.debug("Media type not supported", (Throwable)e);
        this.handle(req, resp, UNSUPPORT_MEDIA, e.getMessage());
    }

    @ExceptionHandler(value={BaseUncheckedException.class})
    public void handle(HttpServletRequest req, HttpServletResponse resp, BaseUncheckedException e) {
        LOGGER.debug("Biz operate failure", (Throwable)e);
        this.handle(req, resp, e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={Throwable.class})
    public void handle(HttpServletRequest req, HttpServletResponse resp, Throwable t) {
        LOGGER.error("Server error", t);
        String message = LOGGER.isDebugEnabled() ? Throwables.getStackTraceAsString((Throwable)t) : this.defaultErrorMsg;
        this.handle(req, resp, this.serverErrorPage, SERVER_ERROR, message);
    }

    protected void handle(HttpServletRequest req, HttpServletResponse resp, String page, int code, String message) {
        if (page == null || LOGGER.isDebugEnabled() || WebUtils.isAjax(req)) {
            WebUtils.respJson(resp, Result.failure(code, message));
        } else {
            this.handErrorPage(req, resp, page);
        }
    }

    protected void handErrorPage(HttpServletRequest req, HttpServletResponse resp, String page) {
        try {
            req.getRequestDispatcher(page).forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException | ServletException e) {
            LOGGER.error("Forward page occur error.", e);
        }
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp, List<ObjectError> errors) {
        String message = errors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(",", "[", "]"));
        this.handle(req, resp, BAD_REQUEST, message);
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp, int code, String message) {
        this.handle(req, resp, null, code, message);
    }
}

