/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.web;

import cn.ponfee.commons.web.DevicePlatform;
import cn.ponfee.commons.web.DeviceType;
import cn.ponfee.commons.web.LiteDevice;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;

public class LiteDeviceResolver {
    private final List<String> normalUserAgentKeywords = new ArrayList<String>();
    private static final List<String> KNOWN_MOBILE_USER_AGENT_PREFIXES = ImmutableList.of((Object)"w3c ", (Object)"w3c-", (Object)"acs-", (Object)"alav", (Object)"alca", (Object)"amoi", (Object)"audi", (Object)"avan", (Object)"benq", (Object)"bird", (Object)"blac", (Object)"blaz", (Object[])new String[]{"brew", "cell", "cldc", "cmd-", "dang", "doco", "eric", "hipt", "htc_", "inno", "ipaq", "ipod", "jigs", "kddi", "keji", "leno", "lg-c", "lg-d", "lg-g", "lge-", "lg/u", "maui", "maxo", "midp", "mits", "mmef", "mobi", "mot-", "moto", "mwbp", "nec-", "newt", "noki", "palm", "pana", "pant", "phil", "play", "port", "prox", "qwap", "sage", "sams", "sany", "sch-", "sec-", "send", "seri", "sgh-", "shar", "sie-", "siem", "smal", "smar", "sony", "sph-", "symb", "t-mo", "teli", "tim-", "tosh", "tsm-", "upg1", "upsi", "vk-v", "voda", "wap-", "wapa", "wapi", "wapp", "wapr", "webc", "winw", "winw", "xda ", "xda-"});
    private static final List<String> KNOWN_MOBILE_USER_AGENT_KEYWORDS = ImmutableList.of((Object)"blackberry", (Object)"webos", (Object)"ipod", (Object)"lge vx", (Object)"midp", (Object)"maemo", (Object)"mmp", (Object)"mobile", (Object)"netfront", (Object)"hiptop", (Object)"nintendo DS", (Object)"novarra", (Object[])new String[]{"openweb", "opera mobi", "opera mini", "palm", "psp", "phone", "smartphone", "symbian", "up.browser", "up.link", "wap", "windows ce"});
    private static final List<String> KNOWN_TABLET_USER_AGENT_KEYWORDS = ImmutableList.of((Object)"ipad", (Object)"playbook", (Object)"hp-tablet", (Object)"kindle");

    public LiteDeviceResolver() {
        this(null);
    }

    public LiteDeviceResolver(List<String> normalUserAgentKeywords) {
        if (CollectionUtils.isNotEmpty(normalUserAgentKeywords)) {
            this.normalUserAgentKeywords.addAll(normalUserAgentKeywords);
        }
    }

    public LiteDevice resolveDevice(HttpServletRequest request) {
        String prefix;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            userAgent = userAgent.toLowerCase();
            for (String string : this.normalUserAgentKeywords) {
                if (!userAgent.contains(string)) continue;
                return this.resolveFallback(request);
            }
        }
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).contains("android") && !userAgent.contains("mobile")) {
                return this.resolveWithPlatform(DeviceType.TABLET, DevicePlatform.ANDROID);
            }
            if (userAgent.contains("ipad")) {
                return this.resolveWithPlatform(DeviceType.TABLET, DevicePlatform.IOS);
            }
            if (userAgent.contains("silk") && !userAgent.contains("mobile")) {
                return this.resolveWithPlatform(DeviceType.TABLET, DevicePlatform.UNKNOWN);
            }
            for (String string : KNOWN_TABLET_USER_AGENT_KEYWORDS) {
                if (!userAgent.contains(string)) continue;
                return this.resolveWithPlatform(DeviceType.TABLET, DevicePlatform.UNKNOWN);
            }
        }
        if (request.getHeader("x-wap-profile") != null || request.getHeader("Profile") != null) {
            if (userAgent != null) {
                if (userAgent.contains("android")) {
                    return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.ANDROID);
                }
                if (userAgent.contains("iphone") || userAgent.contains("ipod") || userAgent.contains("ipad")) {
                    return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.IOS);
                }
            }
            return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
        }
        if (userAgent != null && userAgent.length() >= 4 && KNOWN_MOBILE_USER_AGENT_PREFIXES.contains(prefix = userAgent.substring(0, 4).toLowerCase())) {
            return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
        }
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("wap")) {
            return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
        }
        if (userAgent != null) {
            if (userAgent.contains("android")) {
                return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.ANDROID);
            }
            if (userAgent.contains("iphone") || userAgent.contains("ipod") || userAgent.contains("ipad")) {
                return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.IOS);
            }
            for (String keyword : KNOWN_MOBILE_USER_AGENT_KEYWORDS) {
                if (!userAgent.contains(keyword)) continue;
                return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
            }
        }
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String header = (String)enumeration.nextElement();
            if (!header.contains("OperaMini")) continue;
            return this.resolveWithPlatform(DeviceType.MOBILE, DevicePlatform.UNKNOWN);
        }
        return this.resolveFallback(request);
    }

    protected LiteDevice resolveWithPlatform(DeviceType deviceType, DevicePlatform devicePlatform) {
        return LiteDevice.from(deviceType, devicePlatform);
    }

    protected LiteDevice resolveFallback(HttpServletRequest request) {
        return LiteDevice.NORMAL_INSTANCE;
    }
}

