/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.web;

import cn.ponfee.commons.http.ContentType;
import cn.ponfee.commons.io.ByteOrderMarks;
import cn.ponfee.commons.io.GzipProcessor;
import cn.ponfee.commons.json.Jsons;
import cn.ponfee.commons.util.Networks;
import cn.ponfee.commons.util.URLCodes;
import cn.ponfee.commons.web.LiteDevice;
import cn.ponfee.commons.web.LiteDeviceResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class WebUtils {
    private static final Pattern PATTERN_SUFFIX = Pattern.compile("\\S*[?]\\S*");
    public static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String AUTH_HEADER = "X-Auth-Token";
    public static final String AUTH_COOKIE = "auth_token";
    public static final String AUTH_PARAME = "authToken";
    public static final String COOKIE_ROOT_PATH = "/";
    private static final List<String> LOCAL_IPS = Arrays.asList("127.0.0.1", "0:0:0:0:0:0:0:1", "::1");

    public static Map<String, String> getParams(HttpServletRequest request) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            params.put((String)entry.getKey(), StringUtils.join((Object[])((Object[])entry.getValue()), (String)","));
        }
        return params;
    }

    public static String getText(HttpServletRequest request) {
        return WebUtils.getText(request, "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getText(HttpServletRequest request, String charset) {
        try (ServletInputStream input = request.getInputStream();){
            String string = IOUtils.toString((InputStream)input, (String)charset);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("read request input stream error", e);
        }
    }

    public static String getClientIp(HttpServletRequest req) {
        String ip = req.getHeader("x-forwarded-for");
        boolean invalid = WebUtils.isInvalidIp(ip);
        if (invalid) {
            ip = req.getHeader("Proxy-Client-IP");
        }
        if (invalid && (invalid = WebUtils.isInvalidIp(ip))) {
            ip = req.getHeader("WL-Proxy-Client-IP");
        }
        if (invalid && (invalid = WebUtils.isInvalidIp(ip))) {
            ip = req.getHeader("HTTP_CLIENT_IP");
        }
        if (invalid && (invalid = WebUtils.isInvalidIp(ip))) {
            ip = req.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (invalid && (invalid = WebUtils.isInvalidIp(ip))) {
            ip = req.getHeader("X-Real-IP");
        }
        if (invalid && (invalid = WebUtils.isInvalidIp(ip))) {
            ip = req.getRemoteAddr();
        }
        if (ip != null && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        if (LOCAL_IPS.contains(ip)) {
            ip = Networks.HOST_IP;
        }
        return ip;
    }

    public static LiteDevice getClientDevice(HttpServletRequest req) {
        return new LiteDeviceResolver().resolveDevice(req);
    }

    public static boolean isAjax(HttpServletRequest req) {
        return "XMLHttpRequest".equals(req.getHeader("X-Requested-With"));
    }

    public static String userAgent(HttpServletRequest req) {
        return req.getHeader("User-Agent");
    }

    public static void response(HttpServletResponse resp, ContentType contentType, String text, String charset) {
        resp.setContentType(contentType.value() + ";charset=" + charset);
        resp.setCharacterEncoding(charset);
        try (PrintWriter writer = resp.getWriter();){
            writer.write(text);
        }
        catch (IOException e) {
            throw new RuntimeException("response " + (Object)((Object)contentType) + " occur error", e);
        }
    }

    public static void respJson(HttpServletResponse resp, Object data) {
        WebUtils.respJson(resp, data, "UTF-8");
    }

    public static void respJson(HttpServletResponse resp, Object data, String charset) {
        WebUtils.response(resp, ContentType.APPLICATION_JSON, WebUtils.toJson(data), charset);
    }

    public static void respJsonp(HttpServletResponse response, String callback, Object data) {
        WebUtils.respJsonp(response, callback, data, "UTF-8");
    }

    public static void respJsonp(HttpServletResponse resp, String callback, Object data, String charset) {
        WebUtils.respJson(resp, callback + "(" + WebUtils.toJson(data) + ");", charset);
    }

    public static void download(HttpServletResponse resp, byte[] data, String filename) {
        WebUtils.download(resp, data, filename, "UTF-8", false, false);
    }

    public static void download(HttpServletResponse resp, byte[] data, String filename, String charset, boolean isGzip, boolean withBom) {
        WebUtils.download(resp, new ByteArrayInputStream(data), filename, charset, isGzip, withBom);
    }

    public static void download(HttpServletResponse resp, InputStream input, String filename) {
        WebUtils.download(resp, input, filename, "UTF-8", false, false);
    }

    public static void download(HttpServletResponse resp, InputStream input, String filename, String charset, boolean isGzip, boolean withBom) {
        try (InputStream in = input;
             ServletOutputStream out = resp.getOutputStream();){
            byte[] bom;
            WebUtils.addStreamHeader(resp, filename, charset);
            byte[] byArray = bom = withBom ? ByteOrderMarks.get(Charset.forName(charset)) : null;
            if (isGzip) {
                resp.setHeader("Content-Encoding", "gzip");
                if (bom != null) {
                    GzipProcessor.compress(new SequenceInputStream(new ByteArrayInputStream(bom), in), (OutputStream)out);
                } else {
                    GzipProcessor.compress(in, (OutputStream)out);
                }
            } else {
                if (bom != null) {
                    out.write(bom);
                }
                IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("response input stream occur error", e);
        }
    }

    public static void response(HttpServletResponse resp, byte[] data, ContentType contentType, boolean isGzip) {
        WebUtils.response(resp, new ByteArrayInputStream(data), contentType, isGzip);
    }

    public static void response(HttpServletResponse resp, InputStream input, ContentType contentType, boolean isGzip) {
        try (ServletOutputStream output = resp.getOutputStream();){
            resp.setContentType(contentType.value());
            if (isGzip) {
                resp.setHeader("Content-Encoding", "gzip");
                GzipProcessor.compress(input, (OutputStream)output);
            } else {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("response byte array data occur error", e);
        }
    }

    public static void cors(HttpServletRequest req, HttpServletResponse resp) {
        String origin = req.getHeader("Origin");
        origin = StringUtils.isEmpty((CharSequence)origin) ? "*" : origin;
        resp.setHeader("Access-Control-Allow-Origin", origin);
        String headers = req.getHeader("Access-Control-Allow-Headers");
        headers = StringUtils.isEmpty((CharSequence)headers) ? "Origin,No-Cache,X-Requested-With,If-Modified-Since,Pragma,Expires,Last-Modified,Cache-Control,Content-Type,X-E4M-With" : headers;
        resp.setHeader("Access-Control-Allow-Headers", headers);
        resp.setHeader("Access-Control-Allow-Methods", "GET,POST,PUT,DELETE,HEAD,OPTIONS");
        resp.setHeader("Access-Control-Max-Age", "0");
        resp.setHeader("Access-Control-Allow-Credentials", "true");
        resp.setHeader("XDomainRequestAllowed", "1");
    }

    public static String getUrlSuffix(HttpServletRequest req) {
        String url = req.getRequestURI();
        if (!url.contains(".")) {
            return null;
        }
        String[] pathInfos = url.split(COOKIE_ROOT_PATH);
        String endUrl = pathInfos[pathInfos.length - 1];
        if (PATTERN_SUFFIX.matcher(url).find()) {
            String[] spEndUrl = endUrl.split("\\?");
            return spEndUrl[0].split("\\.")[1];
        }
        return endUrl.split("\\.")[1];
    }

    public static String xssReplace(String text) {
        return StringUtils.replaceEach((String)text, (String[])new String[]{"<", ">", "%3c", "%3e"}, (String[])new String[]{"&lt;", "&gt;", "&lt;", "&gt;"});
    }

    public static String getCookie(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void delCookie(HttpServletRequest req, HttpServletResponse resp, String name) {
        WebUtils.delCookie(req, resp, COOKIE_ROOT_PATH, name);
    }

    public static void delCookie(HttpServletRequest req, HttpServletResponse resp, String path, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            cookie.setPath(path);
            cookie.setMaxAge(0);
            cookie.setValue("");
            resp.addCookie(cookie);
            return;
        }
    }

    public static void addCookie(HttpServletResponse response, String name, String value) {
        WebUtils.addCookie(response, name, value, COOKIE_ROOT_PATH, 86400);
    }

    public static void addCookie(HttpServletResponse resp, String name, String value, String path, int maxAge) {
        resp.addCookie(WebUtils.createCookie(name, value, path, maxAge));
    }

    public static Cookie createCookie(String name, String value, String path, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        return cookie;
    }

    public static void setSessionTrace(HttpServletResponse response, String token) {
        int maxAge = token == null ? 0 : 86400;
        WebUtils.addCookie(response, AUTH_COOKIE, token, COOKIE_ROOT_PATH, maxAge);
        response.addHeader(AUTH_HEADER, token);
    }

    public static String getSessionTrace(HttpServletRequest request) {
        String authToken = request.getParameter(AUTH_PARAME);
        if (authToken != null) {
            return authToken;
        }
        authToken = WebUtils.getCookie(request, AUTH_COOKIE);
        if (authToken != null) {
            return authToken;
        }
        return request.getHeader(AUTH_HEADER);
    }

    public static String getContextPath(ServletContext context) {
        String contextPath = WebUtils.normalize(URLCodes.decodeURI(context.getContextPath()));
        if (COOKIE_ROOT_PATH.equals(contextPath)) {
            contextPath = "";
        }
        return contextPath;
    }

    public static String getContextPath(HttpServletRequest request) {
        String encoding;
        String contextPath = (String)request.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        contextPath = (encoding = request.getCharacterEncoding()) == null ? URLCodes.decodeURI(contextPath) : URLCodes.decodeURI(contextPath, encoding);
        if (COOKIE_ROOT_PATH.equals(contextPath = WebUtils.normalize(contextPath))) {
            contextPath = "";
        }
        return contextPath;
    }

    public static String normalize(String path) {
        return WebUtils.normalize(path, true);
    }

    public static String normalize(String path, boolean replaceBackSlash) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (replaceBackSlash && normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if ("/.".equals(normalized)) {
            return COOKIE_ROOT_PATH;
        }
        if (!normalized.startsWith(COOKIE_ROOT_PATH)) {
            normalized = COOKIE_ROOT_PATH + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    private static String toJson(Object data) {
        return data instanceof CharSequence ? data.toString() : Jsons.toJson(data);
    }

    private static void addStreamHeader(HttpServletResponse resp, String filename, String charset) {
        filename = URLCodes.encodeURIComponent(filename, charset);
        resp.setContentType(ContentType.APPLICATION_OCTET_STREAM.value());
        resp.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        resp.setCharacterEncoding(charset);
    }

    private static boolean isInvalidIp(String ip) {
        return StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip);
    }
}

