/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.ws.adapter;

import cn.ponfee.commons.reflect.GenericUtils;
import cn.ponfee.commons.ws.adapter.model.MapEntry;
import cn.ponfee.commons.ws.adapter.model.MapItem;
import cn.ponfee.commons.ws.adapter.model.MapItemArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public abstract class ListMapAdapter<K, V>
extends XmlAdapter<MapItemArray, List<Map<K, V>>> {
    protected final Class<K> ktype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 0);
    protected final Class<V> vtype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 1);

    protected ListMapAdapter() {
    }

    public List<Map<K, V>> unmarshal(MapItemArray v) {
        if (v == null) {
            return null;
        }
        if (v.getItems() == null) {
            return Lists.newArrayList();
        }
        ArrayList<Map<K, V>> list = new ArrayList<Map<K, V>>();
        for (MapItem items : v.getItems()) {
            if (items == null) continue;
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (MapEntry item : items.getItem()) {
                map.put(item.getKey(), item.getValue());
            }
            list.add(map);
        }
        return list;
    }

    public MapItemArray marshal(List<Map<K, V>> v) {
        if (v == null) {
            return null;
        }
        MapItem[] items = new MapItem[v.size()];
        int i = 0;
        for (Map<K, V> map : v) {
            if (map == null) continue;
            MapEntry[] item = new MapEntry[map.size()];
            int j = 0;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                item[j++] = new MapEntry<K, V>(entry);
            }
            items[i++] = new MapItem(item);
        }
        return new MapItemArray(items);
    }
}

