/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.ws.adapter;

import cn.ponfee.commons.model.Result;
import cn.ponfee.commons.reflect.GenericUtils;
import cn.ponfee.commons.ws.adapter.model.MapEntry;
import cn.ponfee.commons.ws.adapter.model.MapItem;
import cn.ponfee.commons.ws.adapter.model.MapItemArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public abstract class ResultListMapAdapter<K, V>
extends XmlAdapter<Result<MapItemArray>, Result<List<Map<K, V>>>> {
    protected final Class<K> ktype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 0);
    protected final Class<V> vtype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 1);

    protected ResultListMapAdapter() {
    }

    public Result<List<Map<K, V>>> unmarshal(Result<MapItemArray> v) {
        if (v.getData() == null) {
            return v.from(null);
        }
        if (v.getData().getItems() == null) {
            return v.from(Lists.newArrayList());
        }
        ArrayList<LinkedHashMap> list = new ArrayList<LinkedHashMap>();
        for (MapItem items : v.getData().getItems()) {
            if (items == null) continue;
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (MapEntry item : items.getItem()) {
                if (item == null) continue;
                map.put(item.getKey(), item.getValue());
            }
            list.add(map);
        }
        return v.from(list);
    }

    public Result<MapItemArray> marshal(Result<List<Map<K, V>>> v) {
        if (v.getData() == null) {
            return v.from(null);
        }
        MapItem[] items = new MapItem[v.getData().size()];
        int i = 0;
        for (Map<K, V> map : v.getData()) {
            if (map == null) continue;
            MapEntry[] item = new MapEntry[map.size()];
            int j = 0;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                item[j++] = new MapEntry<K, V>(entry);
            }
            items[i++] = new MapItem(item);
        }
        return v.from(new MapItemArray(items));
    }
}

