/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.alert.configuration;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.core.alert.AlertType;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="disjob.alert.alerter")
public class AlerterProperties
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 3369292434171863341L;
    private Map<AlertType, String[]> typeChannelsMap = new EnumMap<AlertType, String[]>(AlertType.class);
    private SendThreadPool sendThreadPool = new SendThreadPool();
    private SendRateLimit sendRateLimit = new SendRateLimit();

    public void setTypeChannelsMap(Map<AlertType, String[]> typeChannelsMap) {
        this.typeChannelsMap = typeChannelsMap;
    }

    public void setSendThreadPool(SendThreadPool sendThreadPool) {
        this.sendThreadPool = sendThreadPool;
    }

    public void setSendRateLimit(SendRateLimit sendRateLimit) {
        this.sendRateLimit = sendRateLimit;
    }

    public Map<AlertType, String[]> getTypeChannelsMap() {
        return this.typeChannelsMap;
    }

    public SendThreadPool getSendThreadPool() {
        return this.sendThreadPool;
    }

    public SendRateLimit getSendRateLimit() {
        return this.sendRateLimit;
    }

    public static class SendRateLimit
    extends ToJsonString {
        private int maxRequests = 20;
        private long windowSizeInMillis = 1000L;

        public int getMaxRequests() {
            return this.maxRequests;
        }

        public long getWindowSizeInMillis() {
            return this.windowSizeInMillis;
        }

        public void setMaxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
        }

        public void setWindowSizeInMillis(long windowSizeInMillis) {
            this.windowSizeInMillis = windowSizeInMillis;
        }
    }

    public static class SendThreadPool
    extends ToJsonString {
        private int corePoolSize = 2;
        private int maximumPoolSize = 8;
        private int queueCapacity = 100;
        private int keepAliveTimeSeconds = 300;
        private boolean allowCoreThreadTimeOut = true;
        private int awaitTerminationSeconds = 3;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public int getKeepAliveTimeSeconds() {
            return this.keepAliveTimeSeconds;
        }

        public boolean isAllowCoreThreadTimeOut() {
            return this.allowCoreThreadTimeOut;
        }

        public int getAwaitTerminationSeconds() {
            return this.awaitTerminationSeconds;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public void setKeepAliveTimeSeconds(int keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
        }

        public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        }

        public void setAwaitTerminationSeconds(int awaitTerminationSeconds) {
            this.awaitTerminationSeconds = awaitTerminationSeconds;
        }
    }
}

