/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.alert.base;

import cn.ponfee.disjob.alert.base.AlertEvent;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.enums.RunType;
import java.util.Date;

public class AlertInstanceEvent
extends AlertEvent {
    private static final long serialVersionUID = 5213948727010283020L;
    private String jobName;
    private long jobId;
    private long instanceId;
    private RunType runType;
    private RunState runState;
    private Date triggerTime;
    private Date runStartTime;
    private Date runEndTime;
    private int retriedCount;

    @Override
    public String buildTitle() {
        return String.format("\u3010\u5b9e\u4f8b-%s | %s\u3011", this.alertType.desc(), AlertInstanceEvent.formatDate(new Date()));
    }

    @Override
    public String buildContent(String format) {
        StringBuilder content = new StringBuilder();
        content.append(String.format(format, "\u5206\u7ec4\u540d\u79f0\uff1a", this.group));
        content.append(String.format(format, "\u4f5c\u4e1a\u540d\u79f0\uff1a", this.jobName));
        content.append(String.format(format, "\u4f5c\u4e1aID\uff1a", this.jobId));
        content.append(String.format(format, "\u5b9e\u4f8bID\uff1a", this.instanceId));
        content.append(String.format(format, "\u8fd0\u884c\u7c7b\u578b\uff1a", this.runType.desc()));
        content.append(String.format(format, "\u8fd0\u884c\u72b6\u6001\uff1a", this.runState.desc()));
        content.append(String.format(format, "\u8ba1\u5212\u89e6\u53d1\u65f6\u95f4\uff1a", AlertInstanceEvent.formatDate(this.triggerTime)));
        content.append(String.format(format, "\u8fd0\u884c\u5f00\u59cb\u65f6\u95f4\uff1a", AlertInstanceEvent.formatDate(this.runStartTime)));
        content.append(String.format(format, "\u8fd0\u884c\u7ed3\u675f\u65f6\u95f4\uff1a", AlertInstanceEvent.formatDate(this.runEndTime)));
        if (this.retriedCount > 0) {
            content.append(String.format(format, "\u5df2\u91cd\u8bd5\u7684\u6b21\u6570\uff1a", this.retriedCount));
        }
        return content.toString();
    }

    public String getJobName() {
        return this.jobName;
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public RunType getRunType() {
        return this.runType;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public Date getTriggerTime() {
        return this.triggerTime;
    }

    public Date getRunStartTime() {
        return this.runStartTime;
    }

    public Date getRunEndTime() {
        return this.runEndTime;
    }

    public int getRetriedCount() {
        return this.retriedCount;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public void setRunType(RunType runType) {
        this.runType = runType;
    }

    public void setRunState(RunState runState) {
        this.runState = runState;
    }

    public void setTriggerTime(Date triggerTime) {
        this.triggerTime = triggerTime;
    }

    public void setRunStartTime(Date runStartTime) {
        this.runStartTime = runStartTime;
    }

    public void setRunEndTime(Date runEndTime) {
        this.runEndTime = runEndTime;
    }

    public void setRetriedCount(int retriedCount) {
        this.retriedCount = retriedCount;
    }
}

