/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.alert.sender;

import cn.ponfee.disjob.alert.base.AlertEvent;
import cn.ponfee.disjob.alert.sender.AlertRecipientMapper;
import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public abstract class AlertSender
extends SingletonClassConstraint {
    private static final Map<String, AlertSender> ALERT_SENDERS = new HashMap<String, AlertSender>();
    private final String channel;
    private final String name;
    private final AlertRecipientMapper alertRecipientMapper;

    protected AlertSender(String channel, String name, AlertRecipientMapper mapper) {
        Assert.hasText((String)channel, (String)"Alert sender channel cannot be blank.");
        Assert.hasText((String)name, (String)"Alert sender name cannot be blank.");
        this.channel = channel.trim();
        this.name = name.trim();
        this.alertRecipientMapper = Objects.requireNonNull(mapper);
        AlertSender.register(this);
    }

    public final void send(AlertEvent alertEvent, Set<String> alertRecipients, String alertWebhook) {
        Map<String, String> alertRecipientMap = this.alertRecipientMapper.mapping(alertRecipients);
        if (this.verify(alertRecipientMap, alertWebhook)) {
            this.send(alertEvent, alertRecipientMap, alertWebhook);
        }
    }

    protected boolean verify(Map<String, String> alertRecipientMap, String alertWebhook) {
        return MapUtils.isNotEmpty(alertRecipientMap) || StringUtils.isNotBlank((CharSequence)alertWebhook);
    }

    protected abstract void send(AlertEvent var1, Map<String, String> var2, String var3);

    public static List<AlertSender> all() {
        return new ArrayList<AlertSender>(ALERT_SENDERS.values());
    }

    public static AlertSender get(String channel) {
        return ALERT_SENDERS.get(channel);
    }

    private static synchronized void register(AlertSender alertSender) {
        String channel = alertSender.channel;
        if (ALERT_SENDERS.containsKey(channel)) {
            throw new Error("Alert sender channel '" + channel + "' already registered!");
        }
        ALERT_SENDERS.put(channel, alertSender);
    }

    public String getChannel() {
        return this.channel;
    }

    public String getName() {
        return this.name;
    }

    public AlertRecipientMapper getAlertRecipientMapper() {
        return this.alertRecipientMapper;
    }
}

