/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.alert.im;

import cn.ponfee.disjob.alert.base.AlertEvent;
import cn.ponfee.disjob.alert.im.ImAlertSupplier;
import cn.ponfee.disjob.alert.im.configuration.ImAlertSenderProperties;
import cn.ponfee.disjob.alert.sender.AlertRecipientMapper;
import cn.ponfee.disjob.alert.sender.AlertSender;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImAlertSender
extends AlertSender {
    private static final Logger log = LoggerFactory.getLogger(ImAlertSender.class);
    public static final String CHANNEL = "im";
    private static final Logger LOG = LoggerFactory.getLogger(ImAlertSender.class);
    private final ImAlertSenderProperties config;

    public ImAlertSender(ImAlertSenderProperties config, AlertRecipientMapper mapper) {
        super(CHANNEL, "Instant Messaging", mapper);
        this.config = config;
        LOG.info("Instant Messaging alert sender initialized: {}", (Object)config);
    }

    protected void send(AlertEvent alertEvent, Map<String, String> alertRecipientMap, String alertWebhook) {
        if (StringUtils.isBlank((CharSequence)alertWebhook)) {
            LOG.warn("Alert instant messaging webhook is empty.");
            return;
        }
        String title = alertEvent.buildTitle();
        String content = alertEvent.buildContent("**%s**%s\n");
        String message = StringUtils.replaceEach((String)content, (String[])new String[]{"\\", "\"", "\n"}, (String[])new String[]{"\\\\", "\\\"", "\\n"});
        ImAlertSupplier supplier = this.config.getSupplier();
        try {
            String payload = this.buildPayload(title, message, supplier);
            this.doPost(alertWebhook, payload);
            LOG.info("Alert event instant messaging sent success: {}, {}", (Object)supplier, (Object)alertWebhook);
        }
        catch (Exception e) {
            LOG.error("Alert event instant messaging sent error: " + (Object)((Object)supplier) + ", " + alertWebhook, (Throwable)e);
        }
    }

    private void doPost(String alertWebhook, String payload) throws Exception {
        URL url = new URL(alertWebhook);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        log.info("Alert instant messaging webhook request: {}, {}", (Object)alertWebhook, (Object)payload);
        try (OutputStream writeStream = connection.getOutputStream();){
            writeStream.write(payload.getBytes(StandardCharsets.UTF_8));
        }
        int responseCode = connection.getResponseCode();
        boolean isSuccess = responseCode < 400;
        try (InputStream readStream = isSuccess ? connection.getInputStream() : connection.getErrorStream();){
            String responseBody = IOUtils.toString((InputStream)readStream, (Charset)StandardCharsets.UTF_8);
            if (isSuccess) {
                log.info("Alert instant messaging webhook success: {}, {}", (Object)responseCode, (Object)responseBody);
            } else {
                log.error("Alert instant messaging webhook failed: {}, {}", (Object)responseCode, (Object)responseBody);
            }
        }
    }

    private String buildPayload(String title, String message, ImAlertSupplier supplier) {
        switch (supplier) {
            case DING_TALK: {
                return "{\"msgtype\": \"text\", \"text\": {\"content\": \"" + message + "\"}}";
            }
            case WE_COM: {
                return "{\"text\": {\"content\": \"" + message + "\"}}";
            }
            case LARK: {
                long timestamp = System.currentTimeMillis() / 1000L;
                String secretKey = timestamp + "\n" + this.config.getSecretKey();
                HmacUtils hmacUtils = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, secretKey);
                String signature = Base64.getEncoder().encodeToString(hmacUtils.hmac(ArrayUtils.EMPTY_BYTE_ARRAY));
                String format = "{\"timestamp\":%d,\"sign\":\"%s\",\"msg_type\":\"post\",\"content\":{\"post\":{\"zh_cn\":{\"title\":\"%s\",\"content\":[[{\"tag\":\"text\",\"text\":\"%s\"}]]}}}}";
                return String.format(format, timestamp, signature, title, message);
            }
        }
        throw new UnsupportedOperationException("Unknown instant messaging supplier: " + (Object)((Object)supplier));
    }
}

