/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.alert.sms;

import cn.ponfee.disjob.alert.sms.configuration.SmsAlertSenderProperties;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.dromara.sms4j.aliyun.config.AlibabaConfig;
import org.dromara.sms4j.cloopen.config.CloopenConfig;
import org.dromara.sms4j.core.datainterface.SmsReadConfig;
import org.dromara.sms4j.core.factory.SmsFactory;
import org.dromara.sms4j.emay.config.EmayConfig;
import org.dromara.sms4j.huawei.config.HuaweiConfig;
import org.dromara.sms4j.jdcloud.config.JdCloudConfig;
import org.dromara.sms4j.provider.config.BaseConfig;
import org.dromara.sms4j.tencent.config.TencentConfig;
import org.dromara.sms4j.unisms.config.UniConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SmsAlertReadConfig
implements SmsReadConfig,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SmsAlertReadConfig.class);
    private final SmsAlertSenderProperties config;

    public SmsAlertReadConfig(SmsAlertSenderProperties config) {
        this.config = config;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        SmsFactory.createSmsBlend((SmsReadConfig)this);
        LOG.info("Sms alert read config refreshed.");
    }

    public BaseConfig getSupplierConfig(String configId) {
        Map<String, SmsAlertSenderProperties.SmsBlendProperties> blends = this.config.getBlends();
        SmsAlertSenderProperties.SmsBlendProperties blendProperties = blends.get(configId);
        return blendProperties == null ? null : ConfigFactory.createConfig(configId, blendProperties);
    }

    public List<BaseConfig> getSupplierConfigList() {
        ArrayList<BaseConfig> configList = new ArrayList<BaseConfig>();
        Map<String, SmsAlertSenderProperties.SmsBlendProperties> blends = this.config.getBlends();
        for (Map.Entry<String, SmsAlertSenderProperties.SmsBlendProperties> entry : blends.entrySet()) {
            configList.add(this.getSupplierConfig(entry.getKey()));
        }
        return configList;
    }

    private static class ConfigFactory {
        static final Map<String, Supplier<BaseConfig>> SUPPLIER_MAP = ImmutableMap.of((Object)"tencent", TencentConfig::new, (Object)"alibaba", AlibabaConfig::new, (Object)"huawei", HuaweiConfig::new, (Object)"jdcloud", JdCloudConfig::new, (Object)"unisms", UniConfig::new, (Object)"emay", EmayConfig::new, (Object)"cloopen", CloopenConfig::new);

        private ConfigFactory() {
        }

        static BaseConfig createConfig(String configId, SmsAlertSenderProperties.SmsBlendProperties blendProperties) {
            String supplier = blendProperties.getSupplier().toLowerCase();
            Supplier<BaseConfig> constructor = SUPPLIER_MAP.get(supplier);
            if (constructor == null) {
                throw new UnsupportedOperationException("Unsupported sms supplier: " + supplier);
            }
            BaseConfig baseConfig = constructor.get();
            baseConfig.setConfigId(configId);
            BeanUtils.copyProperties((Object)blendProperties, (Object)baseConfig);
            return baseConfig;
        }
    }
}

