/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.alert.sms;

import cn.ponfee.disjob.alert.base.AlertEvent;
import cn.ponfee.disjob.alert.sender.AlertRecipientMapper;
import cn.ponfee.disjob.alert.sender.AlertSender;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.core.factory.SmsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsAlertSender
extends AlertSender {
    public static final String CHANNEL = "sms";
    private static final Logger LOG = LoggerFactory.getLogger(SmsAlertSender.class);

    public SmsAlertSender(AlertRecipientMapper mapper) {
        super(CHANNEL, "Short Message Service", mapper);
        LOG.info("SMS alert sender initialized.");
    }

    protected void send(AlertEvent alertEvent, Map<String, String> alertRecipientMap, String alertWebhook) {
        if (MapUtils.isEmpty(alertRecipientMap)) {
            LOG.warn("Alert sms phones is empty.");
            return;
        }
        SmsBlend smsBlend = SmsFactory.getSmsBlend();
        String message = alertEvent.buildTitle() + "\n" + alertEvent.buildContent("\t%s%s\n");
        List phones = alertRecipientMap.values().stream().distinct().collect(Collectors.toList());
        try {
            smsBlend.massTexting(phones, message);
            LOG.info("Alert event sms send success: {}", phones);
        }
        catch (Exception e) {
            LOG.error("Alert event sms send error: " + phones, (Throwable)e);
        }
    }
}

