/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.base;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.InvocationHandler;

public class LazyLoader<T>
implements Supplier<T> {
    private final Supplier<T> loader;
    private Optional<T> holder = null;

    private LazyLoader(Supplier<T> loader) {
        this.loader = Objects.requireNonNull(loader);
    }

    public static <T> LazyLoader<T> of(Supplier<T> loader) {
        return new LazyLoader<T>(loader);
    }

    public static <T, R extends T> R of(Class<T> type, Supplier<R> loader) {
        return LazyLoader.of(type, LazyLoader.of(loader));
    }

    public static <T, A> LazyLoader<T> of(Function<A, T> loader, A arg) {
        return new LazyLoader<Object>(() -> loader.apply(arg));
    }

    public static <T, A, R extends T> R of(Class<T> type, Function<A, R> loader, A arg) {
        return LazyLoader.of(type, LazyLoader.of(loader, arg));
    }

    @Override
    public T get() {
        return this.holder().get();
    }

    public void orElse(T defaultValue) {
        this.holder().orElse(defaultValue);
    }

    public void orElseGet(Supplier<? extends T> other) {
        this.holder().orElseGet(other);
    }

    public void ifPresent(Consumer<? super T> consumer) {
        this.holder().ifPresent(consumer);
    }

    private Optional<T> holder() {
        if (this.holder == null) {
            this.holder = Optional.ofNullable(this.loader.get());
        }
        return this.holder;
    }

    private static <T, R extends T> R of(Class<T> type, LazyLoader<R> lazyLoader) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setUseCache(true);
        enhancer.setInterceptDuringConstruction(false);
        enhancer.setCallback((Callback)((InvocationHandler)(beanProxy, method, args) -> method.invoke(lazyLoader.get(), args)));
        return (R)enhancer.create();
    }
}

