/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.base;

import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RetryTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(RetryTemplate.class);

    public static void execute(Throwables.ThrowingRunnable<Throwable> action, int retryMaxCount, long retryBackoffPeriod) throws Throwable {
        RetryTemplate.execute(() -> {
            action.run();
            return Boolean.TRUE;
        }, retryMaxCount, retryBackoffPeriod);
    }

    public static <T> T execute(Throwables.ThrowingSupplier<T, Throwable> action, int retryMaxCount, long retryBackoffPeriod) throws Throwable {
        Assert.isTrue((retryMaxCount >= 0 ? 1 : 0) != 0, (String)"Retry max count cannot less than 0.");
        Assert.isTrue((retryBackoffPeriod > 0L ? 1 : 0) != 0, (String)"Retry backoff period must be greater than 0.");
        int i = 0;
        String traceId = null;
        while (true) {
            try {
                return action.get();
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    LOG.error("Thread interrupted, skip retry.");
                    Thread.currentThread().interrupt();
                    throw e;
                }
                Throwable ex = e;
                if (i < retryMaxCount) {
                    if (traceId == null) {
                        traceId = ObjectUtils.uuid32();
                    }
                    LOG.error("Execute failed, will retrying: " + (i + 1) + " | " + traceId, e);
                    Thread.sleep((long)(i + 1) * retryBackoffPeriod);
                    continue;
                }
                LOG.error("Execute failed, retried max count: " + traceId, e);
                if (++i <= retryMaxCount) continue;
                throw ex;
            }
            break;
        }
    }
}

