/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.springframework.util.Assert;

public abstract class TimingWheel<T extends Timing<T>>
implements Serializable {
    private static final long serialVersionUID = 4500377208898808026L;
    private static final int PROCESS_SLOTS_SIZE = 2;
    private final long tickMs;
    private final long roundMs;
    private final TimingQueue<T>[] wheel;

    public TimingWheel(long tickMs, int ringSize) {
        Assert.isTrue((tickMs > 0L ? 1 : 0) != 0, (String)"Tick milliseconds must be greater than 0");
        Assert.isTrue((ringSize > 0 ? 1 : 0) != 0, (String)"Ring size must be greater than 0");
        this.tickMs = tickMs;
        this.roundMs = tickMs * (long)ringSize;
        TimingQueue[] ring = new TimingQueue[ringSize];
        for (int i = 0; i < ring.length; ++i) {
            ring[i] = new TimingQueue();
        }
        this.wheel = ring;
    }

    public final long getTickMs() {
        return this.tickMs;
    }

    public final int getRingSize() {
        return this.wheel.length;
    }

    protected boolean verify(T timing) {
        return timing != null;
    }

    public final boolean offer(T timing) {
        return this.offer(timing, System.currentTimeMillis() + this.tickMs);
    }

    public final boolean offer(T timing, long leastTimeMillis) {
        if (!this.verify(timing)) {
            return false;
        }
        long slotTimeMillis = Math.max(timing.timing(), leastTimeMillis);
        int ringIndex = this.calculateIndex(slotTimeMillis);
        return this.wheel[ringIndex].offer(timing);
    }

    public final List<T> poll() {
        return this.poll(System.currentTimeMillis());
    }

    public final List<T> poll(long latestTimeMillis) {
        ArrayList<Object> ringTrigger = new ArrayList<Object>();
        int ringIndex = this.calculateIndex(latestTimeMillis);
        long maximumTiming = latestTimeMillis / this.tickMs * this.tickMs + this.tickMs;
        block0: for (int i = 0; i < 2; ++i) {
            Object first;
            TimingQueue<Object> ringTick = this.wheel[(ringIndex - i + this.wheel.length) % this.wheel.length];
            while ((first = (Timing)ringTick.peek()) != null && first.timing() < maximumTiming && (first = ringTick.poll()) != null) {
                if (first.timing() > maximumTiming) {
                    ringTick.offer(first);
                    continue block0;
                }
                ringTrigger.add(first);
            }
        }
        return ringTrigger;
    }

    private int calculateIndex(long timeMillis) {
        return (int)(timeMillis % this.roundMs / this.tickMs);
    }

    private static final class TimingQueue<T extends Timing<T>>
    extends PriorityQueue<T> {
        private static final long serialVersionUID = -1728596471728230208L;

        private TimingQueue() {
        }

        @Override
        public synchronized T poll() {
            return (T)((Timing)super.poll());
        }

        @Override
        public synchronized boolean offer(T timing) {
            return super.offer(timing);
        }
    }

    public static interface Timing<T extends Timing<T>>
    extends Comparable<T> {
        public long timing();

        @Override
        default public int compareTo(T other) {
            return Long.compare(this.timing(), other.timing());
        }
    }
}

