/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.date;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.date.JavaUtilDateFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.springframework.util.Assert;

public enum DatePeriods {
    PER_MILLIS(ChronoUnit.MILLIS, 1),
    PER_SECOND(ChronoUnit.SECONDS, 1),
    MINUTELY(ChronoUnit.MINUTES, 1),
    HOURLY(ChronoUnit.HOURS, 1),
    DAILY(ChronoUnit.DAYS, 1),
    WEEKLY(ChronoUnit.WEEKS, 1),
    MONTHLY(ChronoUnit.MONTHS, 1),
    QUARTERLY(ChronoUnit.MONTHS, 3),
    SEMIANNUAL(ChronoUnit.MONTHS, 6),
    ANNUAL(ChronoUnit.YEARS, 1),
    DECADES(ChronoUnit.DECADES, 1),
    CENTURIES(ChronoUnit.CENTURIES, 1);

    private final ChronoUnit unit;
    private final int multiple;

    private DatePeriods(ChronoUnit unit, int multiple) {
        this.unit = unit;
        this.multiple = multiple;
    }

    public final Segment next(LocalDateTime original, LocalDateTime target, int step, int next) {
        Assert.isTrue((step > 0 ? 1 : 0) != 0, (String)"Step must be positive number.");
        Assert.isTrue((!original.isAfter(target) ? 1 : 0) != 0, (String)"Original date cannot be after target date.");
        long start = (this.unit.between(original, target) / (long)(step *= this.multiple) + (long)next) * (long)step;
        LocalDateTime begin = original.plus(start, this.unit);
        return new Segment(begin, begin.plus(step, this.unit));
    }

    public final Segment next(LocalDateTime target, int step, int next) {
        return this.next(target, target, step, next);
    }

    public final Segment next(LocalDateTime target, int next) {
        return this.next(target, target, 1, next);
    }

    public final Segment next(Date original, Date target, int step, int next) {
        return this.next(Dates.toLocalDateTime(original), Dates.toLocalDateTime(target), step, next);
    }

    public final Segment next(Date target, int step, int next) {
        LocalDateTime original = Dates.toLocalDateTime(target);
        return this.next(original, original, step, next);
    }

    public final Segment next(Date target, int next) {
        LocalDateTime original = Dates.toLocalDateTime(target);
        return this.next(original, original, 1, next);
    }

    public static final class Segment {
        private final Date begin;
        private final Date end;

        private Segment(LocalDateTime begin, LocalDateTime end) {
            this.begin = Dates.toDate(begin);
            this.end = Dates.toDate(end.minus(1L, ChronoUnit.MILLIS));
        }

        public Date begin() {
            return this.begin;
        }

        public Date end() {
            return this.end;
        }

        public String toString() {
            return JavaUtilDateFormat.PATTERN_51.format(this.begin) + " ~ " + JavaUtilDateFormat.PATTERN_51.format(this.end);
        }
    }
}

