/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.lock;

import cn.ponfee.disjob.common.lock.DoInLocked;
import java.sql.PreparedStatement;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public final class DoInDatabaseLocked
implements DoInLocked {
    private static final Logger LOG = LoggerFactory.getLogger(DoInDatabaseLocked.class);
    private final JdbcTemplate jdbcTemplate;
    private final String lockSql;

    public DoInDatabaseLocked(JdbcTemplate jdbcTemplate, String lockSql) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockSql = lockSql;
    }

    @Override
    public <T> T action(Callable<T> caller) {
        return (T)this.jdbcTemplate.execute(connection -> {
            Boolean autoCommit = null;
            PreparedStatement ps = null;
            try {
                autoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                ps = connection.prepareStatement(this.lockSql);
                ps.execute();
                Object v = caller.call();
                return v;
            }
            catch (Throwable t) {
                LOG.error("Do in db lock occur error.", t);
                Object var6_11 = null;
                return var6_11;
            }
            finally {
                try {
                    connection.commit();
                }
                catch (Throwable t) {
                    LOG.error("Commit connection occur error.", t);
                }
                if (autoCommit != null) {
                    try {
                        connection.setAutoCommit(autoCommit);
                    }
                    catch (Throwable t) {
                        LOG.error("Restore connection auto-commit occur error.", t);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        LOG.error("Close prepare statement occur error.", t);
                    }
                }
            }
        });
    }
}

