/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.lock;

import cn.ponfee.disjob.common.lock.RedisLock;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisLockFactory {
    private final transient RedisTemplate<?, ?> redisTemplate;
    private final long sleepMillis;

    public RedisLockFactory(RedisTemplate<?, ?> redisTemplate) {
        this(redisTemplate, 50L);
    }

    public RedisLockFactory(RedisTemplate<?, ?> redisTemplate, long sleepMillis) {
        this.redisTemplate = redisTemplate;
        this.sleepMillis = Math.max(10L, sleepMillis);
    }

    public RedisLock getLock(String lockKey, int timeoutMillis) {
        return new RedisLock(this.redisTemplate, lockKey, timeoutMillis, this.sleepMillis);
    }
}

