/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.model;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.model.PageRequest;
import java.io.Serializable;
import java.util.List;

public class PageResponse<T>
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 3175875483341043538L;
    private List<T> rows;
    private long total;
    private PageRequest request;

    public PageResponse() {
    }

    public PageResponse(List<T> rows, long total) {
        this(rows, total, null);
    }

    public PageResponse(List<T> rows, long total, PageRequest request) {
        this.rows = rows;
        this.total = total;
        this.request = request;
    }

    public int getTotalPages() {
        int pageSize = this.request.getPageSize();
        return (int)((this.total + (long)pageSize - 1L) / (long)pageSize);
    }

    public List<T> getRows() {
        return this.rows;
    }

    public long getTotal() {
        return this.total;
    }

    public PageRequest getRequest() {
        return this.request;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setRequest(PageRequest request) {
        this.request = request;
    }
}

