/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class JdbcTemplateWrapper {
    private final JdbcTemplate jdbcTemplate;

    private JdbcTemplateWrapper(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public static JdbcTemplateWrapper of(JdbcTemplate jdbcTemplate) {
        return new JdbcTemplateWrapper(jdbcTemplate);
    }

    public void execute(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    public <T> T execute(ConnectionCallback<T> action) {
        return (T)this.jdbcTemplate.execute(action);
    }

    public int insert(String sql, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("INSERT "), () -> "Invalid DELETE sql: " + sql);
        return this.jdbcTemplate.update(sql, args);
    }

    public int update(String sql, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("UPDATE "), () -> "Invalid DELETE sql: " + sql);
        return this.jdbcTemplate.update(sql, args);
    }

    public int delete(String sql, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("DELETE "), () -> "Invalid DELETE sql: " + sql);
        return this.jdbcTemplate.update(sql, args);
    }

    public <T> List<T> queryForList(String sql, RowMapper<T> rowMapper, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("SELECT "), () -> "Invalid SELECT sql: " + sql);
        return this.jdbcTemplate.queryForStream(sql, rowMapper, args).collect(Collectors.toList());
    }
}

