/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.spring.LocalizedMethodArguments;
import cn.ponfee.disjob.common.util.Collects;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.ObjectUtils;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class LocalizedMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Set<String> QUERY_PARAM_METHODS = ImmutableSet.of((Object)RequestMethod.GET.name(), (Object)RequestMethod.DELETE.name(), (Object)RequestMethod.HEAD.name(), (Object)RequestMethod.OPTIONS.name());
    private static final String CACHE_ATTRIBUTE_KEY = "LOCALIZED_METHOD_ARGUMENTS";
    private static final Class<? extends Annotation> MARKED_ANNOTATION_TYPE = LocalizedMethodArguments.class;

    public boolean supportsParameter(MethodParameter parameter) {
        if (!(parameter.getExecutable() instanceof Method)) {
            return false;
        }
        return LocalizedMethodArgumentResolver.isAnnotationPresent(parameter.getMethod(), MARKED_ANNOTATION_TYPE) || LocalizedMethodArgumentResolver.isAnnotationPresent(parameter.getDeclaringClass(), MARKED_ANNOTATION_TYPE);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws IOException {
        Object[] arguments;
        Method method = Objects.requireNonNull(parameter.getMethod());
        HttpServletRequest httpServletRequest = (HttpServletRequest)Objects.requireNonNull(webRequest.getNativeRequest(HttpServletRequest.class));
        int parameterIndex = parameter.getParameterIndex();
        if (parameterIndex == 0) {
            arguments = this.parseMethodParameters(method, httpServletRequest);
            if (method.getParameterCount() > 1) {
                httpServletRequest.setAttribute(CACHE_ATTRIBUTE_KEY, (Object)arguments);
            }
        } else {
            arguments = (Object[])httpServletRequest.getAttribute(CACHE_ATTRIBUTE_KEY);
        }
        return Collects.get(arguments, parameterIndex);
    }

    private Object[] parseMethodParameters(Method method, HttpServletRequest request) throws IOException {
        if (QUERY_PARAM_METHODS.contains(request.getMethod())) {
            return this.parseQueryString(method, request.getParameterMap());
        }
        try (ServletInputStream inputStream = request.getInputStream();){
            String body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isEmpty((CharSequence)body)) {
                Object[] objectArray = this.parseQueryString(method, request.getParameterMap());
                return objectArray;
            }
            Object[] objectArray = Jsons.parseMethodArgs(body, method);
            return objectArray;
        }
    }

    private Object[] parseQueryString(Method method, Map<String, String[]> parameterMap) {
        int parameterCount = method.getParameterCount();
        Object[] arguments = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            String argName = "args[" + i + "]";
            String[] array = parameterMap.get(argName);
            Assert.isTrue((array == null || array.length <= 1 ? 1 : 0) != 0, () -> "Argument cannot be multiple value, name: " + argName + ", value: " + Jsons.toJson(array));
            String argValue = Collects.get(array, 0);
            Type argType = method.getGenericParameterTypes()[i];
            arguments[i] = argValue == null ? (argType instanceof Class ? ObjectUtils.cast(null, (Class)argType) : null) : Jsons.fromJson(argValue, argType);
        }
        return arguments;
    }

    private static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation((Method)method, annotationType) != null;
    }

    private static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation(clazz, annotationType) != null;
    }
}

