/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisTemplateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTemplateUtils.class);

    public static <T> T executeScript(RedisTemplate<?, ?> redisTemplate, RedisScript<T> script, ReturnType returnType, int numKeys, byte[][] keysAndArgs) {
        return (T)redisTemplate.execute(conn -> {
            if (conn.isPipelined() || conn.isQueueing()) {
                throw new UnsupportedOperationException("Unsupported pipelined or queueing eval redis lua script.");
            }
            try {
                return conn.evalSha(script.getSha1(), returnType, numKeys, keysAndArgs);
            }
            catch (Exception e) {
                if (RedisTemplateUtils.exceptionContainsNoScriptError(e)) {
                    LOG.info(e.getMessage());
                    return conn.eval(script.getScriptAsString().getBytes(StandardCharsets.UTF_8), returnType, numKeys, keysAndArgs);
                }
                return ExceptionUtils.rethrow((Throwable)e);
            }
        });
    }

    private static boolean exceptionContainsNoScriptError(Throwable e) {
        if (!(e instanceof NonTransientDataAccessException)) {
            return false;
        }
        for (Throwable current = e; current != null; current = current.getCause()) {
            String exMessage = current.getMessage();
            if (exMessage == null || !exMessage.contains("NOSCRIPT")) continue;
            return true;
        }
        return false;
    }
}

