/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.exception.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ResourceScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceScanner.class);
    private final String urlPrefix;
    private final List<String> locationPatterns;

    public ResourceScanner(String ... locationPatterns) {
        this("classpath*:", locationPatterns);
    }

    public ResourceScanner(String urlPrefix, String[] locationPatterns) {
        if (ArrayUtils.isEmpty((Object[])locationPatterns)) {
            locationPatterns = new String[]{"*"};
        }
        this.urlPrefix = urlPrefix;
        this.locationPatterns = Arrays.asList(locationPatterns);
    }

    public Set<Class<?>> scan4class() {
        return this.scan4class(null, null);
    }

    public Set<Class<?>> scan4class(Class<?>[] assignableTypes, Class<? extends Annotation>[] annotationTypes) {
        LinkedList<TypeFilter> typeFilters = new LinkedList<TypeFilter>();
        if (ArrayUtils.isNotEmpty((Object[])assignableTypes)) {
            Arrays.stream(assignableTypes).map(AssignableTypeFilter::new).forEach(typeFilters::add);
        }
        if (ArrayUtils.isNotEmpty((Object[])annotationTypes)) {
            Arrays.stream(annotationTypes).map(AnnotationTypeFilter::new).forEach(typeFilters::add);
        }
        HashSet result = new HashSet();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory factory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        try {
            for (String locationPattern : this.locationPatterns) {
                for (Resource resource : resolver.getResources(this.urlPrefix + locationPattern)) {
                    MetadataReader reader;
                    if (!resource.isReadable() || !ResourceScanner.matches(typeFilters, reader = factory.getMetadataReader(resource), (MetadataReaderFactory)factory)) continue;
                    try {
                        result.add(Class.forName(reader.getClassMetadata().getClassName()));
                    }
                    catch (Throwable e) {
                        LOG.error("Load class occur error.", e);
                    }
                }
            }
            return result;
        }
        catch (IOException e) {
            return (Set)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public Map<String, byte[]> scan4bytes() {
        return this.scan(IOUtils::toByteArray);
    }

    public Map<String, String> scan4text() {
        return this.scan4text(Charset.defaultCharset());
    }

    public Map<String, String> scan4text(Charset charset) {
        return this.scan(e -> IOUtils.toString((InputStream)e, (Charset)charset));
    }

    private <T> Map<String, T> scan(Throwables.ThrowingFunction<InputStream, T, ?> mapper) {
        HashMap<String, T> result = new HashMap<String, T>(16);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            for (String locationPattern : this.locationPatterns) {
                for (Resource resource : resolver.getResources(this.urlPrefix + locationPattern)) {
                    if (!resource.isReadable()) continue;
                    try (InputStream input = resource.getInputStream();){
                        result.put(resource.getFilename(), mapper.apply(input));
                    }
                    catch (Throwable e) {
                        LOG.error("Resource scan location pattern failed: " + locationPattern, e);
                    }
                }
            }
        }
        catch (IOException e) {
            return (Map)ExceptionUtils.rethrow((Throwable)e);
        }
        return result;
    }

    private static boolean matches(List<TypeFilter> filters, MetadataReader reader, MetadataReaderFactory factory) throws IOException {
        if (filters.isEmpty()) {
            return true;
        }
        for (TypeFilter filter : filters) {
            if (!filter.match(reader, factory)) continue;
            return true;
        }
        return false;
    }
}

