/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import java.util.Arrays;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationContext(ApplicationContext cxt) {
        Class<SpringContextHolder> clazz = SpringContextHolder.class;
        synchronized (SpringContextHolder.class) {
            if (applicationContext != null) {
                throw new IllegalStateException("Spring context holder already initialized.");
            }
            applicationContext = Objects.requireNonNull(cxt);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Object getBean(String beanName) throws BeansException {
        if (applicationContext == null) {
            return null;
        }
        return applicationContext.getBean(beanName);
    }

    public static <T> T getBean(Class<T> beanType) {
        if (applicationContext == null) {
            return null;
        }
        return (T)applicationContext.getBean(beanType);
    }

    public static <T> T getBean(String beanName, Class<T> beanType) {
        if (applicationContext == null) {
            return null;
        }
        return (T)applicationContext.getBean(beanName, beanType);
    }

    public static <T> T getPrototypeBean(String beanName, Class<T> beanType) throws IllegalStateException {
        Object bean;
        if (applicationContext == null) {
            return null;
        }
        try {
            bean = applicationContext.getBean(beanName, beanType);
        }
        catch (BeansException ignored) {
            return null;
        }
        if (applicationContext.isPrototype(beanName)) {
            return (T)bean;
        }
        throw new IllegalStateException("Bean name is not a prototype bean: " + beanName + ", " + beanType);
    }

    public static <T> T getPrototypeBean(Class<T> beanType) throws IllegalStateException {
        Object bean;
        if (applicationContext == null) {
            return null;
        }
        try {
            bean = applicationContext.getBean(beanType);
        }
        catch (BeansException ignored) {
            return null;
        }
        String[] beanNames = applicationContext.getBeanNamesForType(beanType);
        if (Arrays.stream(beanNames).allMatch(arg_0 -> ((ApplicationContext)applicationContext).isPrototype(arg_0))) {
            return (T)bean;
        }
        throw new IllegalStateException("Bean type is not a prototype bean: " + beanType);
    }

    public static boolean containsBean(String beanName) {
        if (applicationContext == null) {
            return false;
        }
        return applicationContext.containsBean(beanName);
    }

    public static Class<?> getType(String beanName) {
        if (applicationContext == null) {
            return null;
        }
        return applicationContext.getType(beanName);
    }

    public static String[] getAliases(String beanName) {
        if (applicationContext == null) {
            return null;
        }
        return applicationContext.getAliases(beanName);
    }

    public static void autowire(Object bean) {
        if (applicationContext == null) {
            return;
        }
        applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
    }
}

