/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.exception.Throwables;
import java.util.function.Consumer;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class TransactionUtils {
    public static void doAfterTransactionCommit(final Runnable action) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronization ts = new TransactionSynchronization(){

                public void afterCommit() {
                    action.run();
                }
            };
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)ts);
        } else {
            action.run();
        }
    }

    public static <R> R doInRequiresNewTransaction(PlatformTransactionManager txManager, Throwables.ThrowingSupplier<R, Throwable> action, Consumer<Throwable> log) {
        return TransactionUtils.doInPropagationTransaction(txManager, action, log, 3);
    }

    public static <R> R doInNestedTransaction(PlatformTransactionManager txManager, Throwables.ThrowingSupplier<R, Throwable> action, Consumer<Throwable> log) {
        Assert.isTrue((boolean)TransactionSynchronizationManager.isActualTransactionActive(), (String)"Do nested transaction must be in parent transaction.");
        return TransactionUtils.doInPropagationTransaction(txManager, action, log, 6);
    }

    private static <R> R doInPropagationTransaction(PlatformTransactionManager txManager, Throwables.ThrowingSupplier<R, Throwable> action, Consumer<Throwable> log, int transactionPropagation) {
        DefaultTransactionDefinition txDefinition = new DefaultTransactionDefinition();
        txDefinition.setPropagationBehavior(transactionPropagation);
        TransactionStatus status = txManager.getTransaction((TransactionDefinition)txDefinition);
        try {
            R result = action.get();
            txManager.commit(status);
            return result;
        }
        catch (Throwable t) {
            txManager.rollback(status);
            log.accept(t);
            return null;
        }
    }
}

