/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.tree;

import cn.ponfee.disjob.common.tree.BaseNode;
import cn.ponfee.disjob.common.tree.TreeNode;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public final class TreeNodeBuilder<T extends Serializable & Comparable<T>, A> {
    private final T nid;
    private Comparator<? super TreeNode<T, A>> siblingNodesComparator = Comparator.comparing(BaseNode::getNid);
    private T pid = null;
    private boolean enabled = true;
    private boolean available = true;
    private A attach = null;
    private boolean buildPath = true;

    TreeNodeBuilder(T nid) {
        this.nid = (Serializable)Objects.requireNonNull(nid);
    }

    public TreeNodeBuilder<T, A> pid(T pid) {
        this.pid = pid;
        return this;
    }

    public TreeNodeBuilder<T, A> siblingNodesComparator(Comparator<? super TreeNode<T, A>> comparator) {
        this.siblingNodesComparator = Objects.requireNonNull(comparator, "Sibling nodes comparator cannot be null.");
        return this;
    }

    public TreeNodeBuilder<T, A> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TreeNodeBuilder<T, A> available(boolean available) {
        this.available = available;
        return this;
    }

    public TreeNodeBuilder<T, A> attach(A attach) {
        this.attach = attach;
        return this;
    }

    public TreeNodeBuilder<T, A> buildPath(boolean buildPath) {
        this.buildPath = buildPath;
        return this;
    }

    public TreeNode<T, A> build() {
        return new TreeNode<T, A>(this.nid, this.pid, this.enabled, this.available, this.attach, this.siblingNodesComparator, this.buildPath, true);
    }
}

