/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class Files {
    public static final int EOF = -1;
    public static final int BUFF_SIZE = 8192;
    public static final String TOP_PATH = "..";
    public static final String CURRENT_PATH = ".";
    public static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String DEFAULT_CHARSET_NAME = DEFAULT_CHARSET.name();
    public static final String UTF_8 = "UTF-8";
    public static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    public static final String UNIX_FOLDER_SEPARATOR = "/";
    public static final String SYSTEM_FOLDER_SEPARATOR = File.separator;
    public static final String UNIX_LINE_SEPARATOR = "\n";
    public static final String WINDOWS_LINE_SEPARATOR = "\r\n";
    public static final String MAC_LINE_SEPARATOR = "\r";
    public static final String SYSTEM_LINE_SEPARATOR;

    public static String tmpDir() {
        String tmpDir = SystemUtils.JAVA_IO_TMPDIR;
        if (!tmpDir.endsWith(File.separator)) {
            tmpDir = tmpDir + File.separator;
        }
        return tmpDir;
    }

    public static File mkdir(String path) {
        File file = new File(path);
        Files.mkdir(file);
        return file;
    }

    public static void mkdir(File file) {
        if (file.isFile()) {
            throw new IllegalStateException(file.getAbsolutePath() + " is a directory.");
        }
        if (file.exists()) {
            return;
        }
        if (file.mkdirs()) {
            file.setLastModified(System.currentTimeMillis());
        }
    }

    public static File touch(String path) {
        File file = new File(path);
        Files.touch(file);
        return file;
    }

    public static void touch(File file) {
        if (file.isDirectory()) {
            throw new IllegalStateException(file.getAbsolutePath() + " is a directory.");
        }
        if (file.exists()) {
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            if (file.createNewFile()) {
                file.setLastModified(System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void deleteQuietly(File file) {
        if (file == null) {
            return;
        }
        try {
            java.nio.file.Files.deleteIfExists(file.toPath());
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
    }

    public static String toString(String file) {
        return Files.toString(new File(file), DEFAULT_CHARSET_NAME);
    }

    public static String toString(File file) {
        return Files.toString(file, DEFAULT_CHARSET_NAME);
    }

    public static String toString(File file, String charsetName) {
        return Files.toString(file, Charset.forName(charsetName));
    }

    /*
     * Exception decompiling
     */
    public static String toString(File file, Charset charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static byte[] toByteArray(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> readLines(File file, String charset) throws FileNotFoundException {
        return Files.readLines(new FileInputStream(file), charset);
    }

    public static List<String> readLines(InputStream input, String charset) {
        LinkedList<String> list = new LinkedList<String>();
        Files.readLines(input, charset, list::add);
        return list;
    }

    public static void readLines(InputStream input, String charset, Consumer<String> consumer) {
        try (Scanner scanner = charset == null ? new Scanner(input) : new Scanner(input, charset);){
            while (scanner.hasNextLine()) {
                consumer.accept(scanner.nextLine());
            }
        }
    }

    public static byte[] readByteArray(InputStream input, int count) throws IOException {
        int index;
        int n;
        byte[] bytes = new byte[count];
        for (index = 0; index < count && (n = input.read(bytes, index, count - index)) != -1; index += n) {
        }
        return index == count ? bytes : Arrays.copyOf(bytes, index);
    }

    public static byte[] readByteArray(File file, int count) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            byte[] byArray = Files.readByteArray(input, count);
            return byArray;
        }
    }

    public static byte[] readByteArray(String filePath, int count) throws IOException {
        return Files.readByteArray(new File(filePath), count);
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.replace((String)path, (String)WINDOWS_FOLDER_SEPARATOR, (String)UNIX_FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains(UNIX_FOLDER_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(UNIX_FOLDER_SEPARATOR)) {
            prefix = prefix + UNIX_FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.split((String)pathToUse, (String)UNIX_FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + String.join((CharSequence)UNIX_FOLDER_SEPARATOR, pathElements);
    }

    public static Charset charset(String charsetName) {
        return charsetName == null ? DEFAULT_CHARSET : Charset.forName(charsetName);
    }

    static {
        StringBuilderWriter buffer = new StringBuilderWriter(4);
        PrintWriter out = new PrintWriter((Writer)buffer);
        out.println();
        SYSTEM_LINE_SEPARATOR = buffer.toString();
        out.close();
    }
}

