/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import org.springframework.util.Assert;

public class Maths {
    public static strictfp double log2(double n) {
        return Maths.log(n, 2.0);
    }

    public static strictfp double log(double n, double base) {
        return Math.log(n) / Math.log(base);
    }

    public static int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    public static long bitsMask(int bits) {
        Assert.isTrue((bits >= 0 && bits <= 64 ? 1 : 0) != 0, (String)"bits must range [0,64].");
        return bits == 64 ? -1L : -1L << bits ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long pow(long base, int exponent) {
        if (exponent == 0) {
            return 1L;
        }
        long result = base;
        while (--exponent > 0) {
            result *= base;
        }
        return result;
    }

    public static int abs(int a) {
        return a == Integer.MIN_VALUE ? Integer.MAX_VALUE : (a < 0 ? -a : a);
    }

    public static long abs(long a) {
        return a == Long.MIN_VALUE ? Long.MAX_VALUE : (a < 0L ? -a : a);
    }

    public static int plus(int a, int b) {
        if (a > 0 && b > 0) {
            return Integer.MAX_VALUE - b < a ? Integer.MAX_VALUE : a + b;
        }
        if (a < 0 && b < 0) {
            return Integer.MIN_VALUE - b > a ? Integer.MIN_VALUE : a + b;
        }
        return a + b;
    }

    public static int minus(int a, int b) {
        if (a > 0 && b < 0) {
            return Integer.MAX_VALUE + b < a ? Integer.MAX_VALUE : a - b;
        }
        if (a < 0 && b > 0) {
            return Integer.MIN_VALUE + b > a ? Integer.MIN_VALUE : a - b;
        }
        return a - b;
    }

    public static long plus(long a, long b) {
        if (a > 0L && b > 0L) {
            return Long.MAX_VALUE - b < a ? Long.MAX_VALUE : a + b;
        }
        if (a < 0L && b < 0L) {
            return Long.MIN_VALUE - b > a ? Long.MIN_VALUE : a + b;
        }
        return a + b;
    }

    public static long minus(long a, long b) {
        if (a > 0L && b < 0L) {
            return Long.MAX_VALUE + b < a ? Long.MAX_VALUE : a - b;
        }
        if (a < 0L && b > 0L) {
            return Long.MIN_VALUE + b > a ? Long.MIN_VALUE : a - b;
        }
        return a - b;
    }

    public static int gcd(int a, int b) {
        int c;
        if (a < 0 || b < 0) {
            throw new ArithmeticException();
        }
        if (a == 0 || b == 0) {
            return Math.abs(a - b);
        }
        while ((c = a % b) != 0) {
            a = b;
            b = c;
        }
        return b;
    }

    public static int gcd(int[] array) {
        int result = array[0];
        for (int i = 1; i < array.length; ++i) {
            result = Maths.gcd(result, array[i]);
        }
        return result;
    }
}

