/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.util.Files;
import java.io.File;

public class MavenProjects {
    private static final String EXCLUSION_STRING = "[\r\n]";

    public static String getProjectBaseDir() {
        String path = Thread.currentThread().getContextClassLoader().getResource("").getFile();
        return Files.cleanPath(new File(path).getParentFile().getParentFile().getPath());
    }

    public static File getMainJavaFile(Class<?> clazz) {
        return new File(MavenProjects.getMainJavaPath("") + clazz.getCanonicalName().replace('.', '/') + ".java");
    }

    public static byte[] getMainJavaFileAsBytes(Class<?> clazz) {
        return Files.toByteArray(MavenProjects.getMainJavaFile(clazz));
    }

    public static String getMainJavaFileAsString(Class<?> clazz) {
        return Files.toString(MavenProjects.getMainJavaFile(clazz)).replaceAll(EXCLUSION_STRING, "");
    }

    public static File getTestJavaFile(Class<?> clazz) {
        return new File(MavenProjects.getTestJavaPath("") + clazz.getCanonicalName().replace('.', '/') + ".java");
    }

    public static byte[] getTestJavaFileAsBytes(Class<?> clazz) {
        return Files.toByteArray(MavenProjects.getTestJavaFile(clazz));
    }

    public static String getTestJavaFileAsString(Class<?> clazz) {
        return Files.toString(MavenProjects.getTestJavaFile(clazz)).replaceAll(EXCLUSION_STRING, "");
    }

    public static String getMainJavaPath(String basePackage) {
        return MavenProjects.getProjectBaseDir() + "/src/main/java/" + basePackage.replace('.', '/');
    }

    public static String getMainJavaPath(String basePackage, String filename) {
        return MavenProjects.getMainJavaPath(basePackage) + "/" + filename;
    }

    public static String getTestJavaPath(String basePackage) {
        return MavenProjects.getProjectBaseDir() + "/src/test/java/" + basePackage.replace('.', '/');
    }

    public static String getTestJavaPath(String basePackage, String filename) {
        return MavenProjects.getTestJavaPath(basePackage) + "/" + filename;
    }

    public static File getMainScalaFile(Class<?> clazz) {
        return new File(MavenProjects.getMainScalaPath("") + clazz.getCanonicalName().replace('.', '/') + ".scala");
    }

    public static byte[] getMainScalaFileAsBytes(Class<?> clazz) {
        return Files.toByteArray(MavenProjects.getMainScalaFile(clazz));
    }

    public static String getMainScalaFileAsString(Class<?> clazz) {
        return Files.toString(MavenProjects.getMainScalaFile(clazz)).replaceAll(EXCLUSION_STRING, "");
    }

    public static File getTestScalaFile(Class<?> clazz) {
        return new File(MavenProjects.getTestScalaPath("") + clazz.getCanonicalName().replace('.', '/') + ".scala");
    }

    public static byte[] getTestScalaFileAsBytes(Class<?> clazz) {
        return Files.toByteArray(MavenProjects.getTestScalaFile(clazz));
    }

    public static String getTestScalaFileAsString(Class<?> clazz) {
        return Files.toString(MavenProjects.getTestScalaFile(clazz)).replaceAll(EXCLUSION_STRING, "");
    }

    public static String getMainScalaPath(String basePackage) {
        return MavenProjects.getProjectBaseDir() + "/src/main/scala/" + basePackage.replace('.', '/');
    }

    public static String getMainScalaPath(String basePackage, String filename) {
        return MavenProjects.getMainScalaPath(basePackage) + "/" + filename;
    }

    public static String getTestScalaPath(String basePackage) {
        return MavenProjects.getProjectBaseDir() + "/src/test/scala/" + basePackage.replace('.', '/');
    }

    public static String getTestScalaPath(String basePackage, String filename) {
        return MavenProjects.getTestScalaPath(basePackage) + "/" + filename;
    }

    public static String getMainResourcesPath() {
        return MavenProjects.getProjectBaseDir() + "/src/main/resources/";
    }

    public static String getMainResourcesPath(String followPath) {
        return MavenProjects.getMainResourcesPath() + followPath;
    }

    public static String getTestResourcesPath() {
        return MavenProjects.getProjectBaseDir() + "/src/test/resources/";
    }

    public static String getTestResourcesPath(String followPath) {
        return MavenProjects.getTestResourcesPath() + followPath;
    }

    public static String getWebAppPath() {
        return MavenProjects.getProjectBaseDir() + "/src/main/webapp/";
    }

    public static String getWebAppPath(String webappPath) {
        return MavenProjects.getWebAppPath() + webappPath;
    }
}

