/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.util.Collects;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetUtils.class);
    public static final String IGNORED_NETWORK_INTERFACE = "disjob.network.interface.ignored";
    public static final String PREFERRED_NETWORK_INTERFACE = "disjob.network.interface.preferred";
    private static final int RND_PORT_START = 30000;
    private static final int RND_PORT_RANGE = 10000;
    private static final int MIN_PORT = 1;
    private static final int MAX_PORT = 65535;
    private static final String LOCAL_HOST_NAME = "localhost";
    private static final String LOCAL_IP_ADDRESS = "127.0.0.1";
    private static final String ANY_IP_ADDRESS = "0.0.0.0";
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final BitSet USED_PORT = new BitSet(65536);
    private static final Map<String, String> HOST_NAME_CACHE = new ConcurrentHashMap<String, String>(100);
    private static volatile String localHost;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConnectableHostPort(String host, int port, int timeout) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailablePort(int port) {
        if (port < 1) return false;
        if (port > 65535) {
            return false;
        }
        if (USED_PORT.get(port)) {
            return false;
        }
        try (ServerSocket ignored = new ServerSocket(port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored2) {
            USED_PORT.set(port);
            return false;
        }
    }

    public static boolean isValidIpAddress(String ip) {
        return IP_ADDRESS_PATTERN.matcher(ip).matches();
    }

    public static boolean isValidLocalHost(String host) {
        return StringUtils.isNotEmpty((CharSequence)host) && !host.equalsIgnoreCase(LOCAL_HOST_NAME) && !host.equals(ANY_IP_ADDRESS) && !host.startsWith("127.");
    }

    public static boolean isAnyHost(String host) {
        return ANY_IP_ADDRESS.equals(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalHost() {
        if (localHost != null) {
            return localHost;
        }
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            String hostAddress;
            if (localHost != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return localHost;
            }
            localHost = hostAddress = Optional.ofNullable(NetUtils.getLocalAddress()).map(InetAddress::getHostAddress).orElse(LOCAL_IP_ADDRESS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return hostAddress;
        }
    }

    public static String getHostName(String hostAddress) {
        if (StringUtils.isEmpty((CharSequence)hostAddress)) {
            return hostAddress;
        }
        int i = hostAddress.indexOf(58);
        if (i != -1) {
            hostAddress = hostAddress.substring(0, i);
        }
        return HOST_NAME_CACHE.computeIfAbsent(hostAddress, addr -> {
            String hostName = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(addr);
                if (inetAddress != null) {
                    hostName = inetAddress.getHostName();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return StringUtils.isEmpty(hostName) ? addr : hostName;
        });
    }

    public static String getHostAddress(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException ignored) {
            return hostName;
        }
    }

    public static int findAvailablePort() {
        return NetUtils.findAvailablePort(NetUtils.getRandomPort());
    }

    public static int findAvailablePort(int startPort) throws IllegalStateException {
        int port;
        startPort = Math.max(startPort, 1);
        for (port = startPort = Math.min(startPort, 65535); port <= 65535; ++port) {
            if (!NetUtils.isAvailablePort(port)) continue;
            return port;
        }
        for (port = startPort - 1; port >= 1; --port) {
            if (!NetUtils.isAvailablePort(port)) continue;
            return port;
        }
        throw new IllegalStateException("Cannot found available socket port.");
    }

    public static boolean isValidIpv4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IP_ADDRESS_PATTERN.matcher(name).matches() && !ANY_IP_ADDRESS.equals(name) && !LOCAL_IP_ADDRESS.equals(name);
    }

    public static NetworkInterface findValidNetworkInterface() {
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (NetUtils.isIgnoredNetworkInterface(networkInterface)) continue;
                validNetworkInterfaces.add(networkInterface);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to get network interface: {}", (Object)e.getMessage());
            return null;
        }
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            if (!NetUtils.isPreferredNetworkInterface(networkInterface)) continue;
            if (NetUtils.getReachableAddress(networkInterface) != null) {
                return networkInterface;
            }
            LOG.warn("Preferred network interface not has reachable address: {}", (Object)networkInterface.getDisplayName());
        }
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            if (NetUtils.getReachableAddress(networkInterface) == null) continue;
            return networkInterface;
        }
        return (NetworkInterface)Collects.getFirst(validNetworkInterfaces);
    }

    private static String getSystemConfig(String name) {
        String value = System.getProperty(name);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        return System.getenv(name);
    }

    private static int getRandomPort() {
        return 30000 + ThreadLocalRandom.current().nextInt(10000);
    }

    private static boolean isReachableAddress(InetAddress address) {
        if (address == null) {
            return false;
        }
        try {
            if (address.isReachable(100)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static InetAddress getReachableAddress(NetworkInterface networkInterface) {
        if (networkInterface == null) {
            return null;
        }
        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = NetUtils.toValidAddress(addresses.nextElement());
            if (!NetUtils.isReachableAddress(address)) continue;
            return address;
        }
        return null;
    }

    private static boolean isPreferIpv6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    private static InetAddress normalizeIpv6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return address;
    }

    private static InetAddress toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (NetUtils.isPreferIpv6Address()) {
                return NetUtils.normalizeIpv6Address(v6Address);
            }
        }
        if (NetUtils.isValidIpv4Address(address)) {
            return address;
        }
        return null;
    }

    private static InetAddress getLocalAddress() {
        InetAddress address;
        try {
            NetworkInterface validNetworkInterface = NetUtils.findValidNetworkInterface();
            address = NetUtils.getReachableAddress(validNetworkInterface);
            if (address != null) {
                return address;
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to get network address: {}", (Object)e.getMessage());
        }
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            address = NetUtils.toValidAddress(localAddress);
            if (address != null) {
                return address;
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to get local host address: {} ", (Object)e.getMessage());
        }
        return localAddress;
    }

    private static boolean isIgnoredNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        if (networkInterface == null || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) {
            return true;
        }
        String ignoredInterfaceNameRegex = NetUtils.getSystemConfig(IGNORED_NETWORK_INTERFACE);
        if (StringUtils.isEmpty((CharSequence)ignoredInterfaceNameRegex)) {
            return false;
        }
        List networkNames = Stream.of(networkInterface.getDisplayName(), networkInterface.getName()).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (networkNames.isEmpty()) {
            return false;
        }
        for (String ignoredNameRegex : ignoredInterfaceNameRegex.split(",")) {
            String regex = ignoredNameRegex.trim();
            try {
                if (!networkNames.stream().anyMatch(e -> e.equals(regex) || e.matches(regex))) continue;
                return true;
            }
            catch (Throwable t) {
                LOG.warn("exception occurred: " + networkNames + " matches " + regex, t);
            }
        }
        return false;
    }

    private static boolean isPreferredNetworkInterface(NetworkInterface networkInterface) {
        if (networkInterface == null) {
            return false;
        }
        String preferredNetworkInterfaceName = NetUtils.getSystemConfig(PREFERRED_NETWORK_INTERFACE);
        return Objects.equals(networkInterface.getDisplayName(), preferredNetworkInterfaceName) || Objects.equals(networkInterface.getName(), preferredNetworkInterfaceName);
    }
}

