/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.util.Enums;
import cn.ponfee.disjob.common.util.Fields;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum PrimitiveTypes {
    DOUBLE(Double.class, -128, -128),
    FLOAT(Float.class, 64, -64),
    LONG(Long.class, 32, -32),
    INT(Integer.class, 16, -16),
    SHORT(Short.class, 8, -8),
    CHAR(Character.class, 4, -12),
    BYTE(Byte.class, 2, -6),
    BOOLEAN(Boolean.class, 1, 1, 1);

    private final Class<?> wrapper;
    private final byte value;
    private final byte castable;
    private final Class<?> primitive;
    private final int size;
    private static final Map<Class<?>, PrimitiveTypes> PRIMITIVE_MAPPING;
    private static final Map<Class<?>, PrimitiveTypes> WRAPPER_MAPPING;

    private PrimitiveTypes(Class<?> wrapper, byte value, byte castable) {
        this(wrapper, value, castable, (Integer)Fields.get(wrapper, "SIZE"));
    }

    private PrimitiveTypes(Class<?> wrapper, byte value, byte castable, int size) {
        this.wrapper = wrapper;
        this.value = value;
        this.castable = castable;
        this.primitive = (Class)Fields.get(wrapper, "TYPE");
        this.size = size;
        Hide.PRIMITIVE_OR_WRAPPER_MAPPING.put(this.primitive, this);
        Hide.PRIMITIVE_OR_WRAPPER_MAPPING.put(wrapper, this);
    }

    public Class<?> primitive() {
        return this.primitive;
    }

    public Class<?> wrapper() {
        return this.wrapper;
    }

    public int size() {
        return this.size;
    }

    public boolean isCastable(PrimitiveTypes target) {
        return (this.castable & target.value) == target.value;
    }

    public static PrimitiveTypes ofPrimitive(Class<?> primitive) {
        return PRIMITIVE_MAPPING.get(primitive);
    }

    public static PrimitiveTypes ofWrapper(Class<?> wrapper) {
        return WRAPPER_MAPPING.get(wrapper);
    }

    public static PrimitiveTypes ofPrimitiveOrWrapper(Class<?> primitive) {
        return (PrimitiveTypes)((Object)Hide.PRIMITIVE_OR_WRAPPER_MAPPING.get(primitive));
    }

    public static Set<Class<?>> allPrimitiveTypes() {
        return PRIMITIVE_MAPPING.keySet();
    }

    public static Set<Class<?>> allWrapperTypes() {
        return WRAPPER_MAPPING.keySet();
    }

    public static boolean isWrapperType(Class<?> primitive) {
        return PrimitiveTypes.ofWrapper(primitive) != null;
    }

    public static <T> Class<T> wrap(Class<T> type) {
        PrimitiveTypes pt = PrimitiveTypes.ofPrimitiveOrWrapper(type);
        return pt == null ? type : pt.wrapper;
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        PrimitiveTypes pt = PrimitiveTypes.ofPrimitiveOrWrapper(type);
        return pt == null ? type : pt.primitive;
    }

    static {
        PRIMITIVE_MAPPING = Enums.toMap(PrimitiveTypes.class, PrimitiveTypes::primitive);
        WRAPPER_MAPPING = Enums.toMap(PrimitiveTypes.class, PrimitiveTypes::wrapper);
    }

    private static class Hide {
        private static final Map<Class<?>, PrimitiveTypes> PRIMITIVE_OR_WRAPPER_MAPPING = new HashMap();

        private Hide() {
        }
    }
}

