/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.base;

import cn.ponfee.disjob.common.base.RetryTemplate;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;

public class RetryInvocationHandler
implements InvocationHandler {
    private final Object target;
    private final int retryMaxCount;
    private final long retryBackoffPeriod;

    public RetryInvocationHandler(Object target, int retryMaxCount, long retryBackoffPeriod) {
        this.target = Objects.requireNonNull(target, "Target object cannot be null.");
        this.retryMaxCount = retryMaxCount;
        this.retryBackoffPeriod = retryBackoffPeriod;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return RetryTemplate.execute(() -> method.invoke(this.target, args), this.retryMaxCount, this.retryBackoffPeriod);
    }
}

