/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.base;

import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.util.UuidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RetryTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(RetryTemplate.class);

    public static void execute(Throwables.ThrowingRunnable<Throwable> action, int retryMaxCount, long retryBackoffPeriod) throws Throwable {
        RetryTemplate.execute(action.toSupplier(Boolean.TRUE), retryMaxCount, retryBackoffPeriod);
    }

    public static <T> T execute(Throwables.ThrowingSupplier<T, Throwable> action, int retryMaxCount, long retryBackoffPeriod) throws Throwable {
        Assert.isTrue((retryMaxCount >= 0 ? 1 : 0) != 0, (String)"Retry max count cannot less than 0.");
        Assert.isTrue((retryBackoffPeriod > 0L ? 1 : 0) != 0, (String)"Retry backoff period must be greater than 0.");
        int i = 0;
        String retryId = null;
        while (true) {
            try {
                return action.get();
            }
            catch (InterruptedException e) {
                LOG.error("Thread interrupted, abort retry.");
                throw e;
            }
            catch (Throwable e) {
                Throwable ex = e;
                if (i < retryMaxCount) {
                    if (retryId == null) {
                        retryId = UuidUtils.uuid32();
                    }
                    LOG.error("Execute failed, will retrying: " + (i + 1) + ", " + retryId, e);
                    Thread.sleep((long)(i + 1) * retryBackoffPeriod);
                    continue;
                }
                LOG.error("Execute failed, retried max count: " + retryId, e);
                if (++i <= retryMaxCount) continue;
                throw ex;
            }
            break;
        }
    }

    public static void executeQuietly(Throwables.ThrowingRunnable<Throwable> action, int retryMaxCount, long retryBackoffPeriod) {
        RetryTemplate.executeQuietly(action.toSupplier(Boolean.TRUE), retryMaxCount, retryBackoffPeriod);
    }

    public static <T> T executeQuietly(Throwables.ThrowingSupplier<T, Throwable> action, int retryMaxCount, long retryBackoffPeriod) {
        try {
            return RetryTemplate.execute(action, retryMaxCount, retryBackoffPeriod);
        }
        catch (Throwable t) {
            Threads.interruptIfNecessary(t);
            return null;
        }
    }
}

