/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.base;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(SingletonClassConstraint.class);
    private static final Set<Class<?>> MUTEX = ConcurrentHashMap.newKeySet();

    protected SingletonClassConstraint() {
        SingletonClassConstraint.constrain(this);
    }

    public static synchronized void constrain(Object instance) {
        Objects.requireNonNull(instance, "Object instance cannot be null.");
        SingletonClassConstraint.constrain(instance.getClass());
    }

    public static synchronized void constrain(Class<?> clazz) {
        if (!MUTEX.add(clazz)) {
            throw new Error("Class '" + clazz + "' instance already created.");
        }
        LOG.info("Class '{}' instance are created.", clazz);
    }
}

