/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.base;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;

public class TextTokenizer
implements Iterator<String> {
    private final String text;
    private final String delimiter;
    private int position;

    public TextTokenizer(String text, String delimiter) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Text token value cannot be empty.");
        }
        if (StringUtils.isEmpty((CharSequence)delimiter)) {
            throw new IllegalArgumentException("Text token delimiter cannot be empty.");
        }
        this.text = text;
        this.delimiter = delimiter;
        this.position = -1;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.text.length();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int begin = ++this.position;
        int end = this.position = this.text.indexOf(this.delimiter, this.position);
        this.position = this.position == -1 ? this.text.length() : this.position + this.delimiter.length() - 1;
        return end == -1 ? this.text.substring(begin) : this.text.substring(begin, end);
    }

    public String tail() {
        return this.text.substring(this.position + 1);
    }
}

