/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import cn.ponfee.disjob.common.concurrent.DelayedData;
import cn.ponfee.disjob.common.concurrent.LoggedUncaughtExceptionHandler;
import cn.ponfee.disjob.common.concurrent.NamedThreadFactory;
import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.concurrent.TripState;
import cn.ponfee.disjob.common.exception.Throwables;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncDelayedExecutor<E>
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDelayedExecutor.class);
    private final Consumer<E> dataProcessor;
    private final ThreadPoolExecutor asyncExecutor;
    private final DelayQueue<DelayedData<E>> queue = new DelayQueue();
    private final TripState state = TripState.createStarted();

    public AsyncDelayedExecutor(Consumer<E> dataProcessor) {
        this(1, dataProcessor);
    }

    public AsyncDelayedExecutor(int maximumPoolSize, Consumer<E> dataProcessor) {
        this.dataProcessor = dataProcessor;
        ThreadPoolExecutor executor = null;
        if (maximumPoolSize > 1) {
            executor = ThreadPoolExecutors.builder().corePoolSize(1).maximumPoolSize(maximumPoolSize).workQueue(new SynchronousQueue<Runnable>()).keepAliveTimeSeconds(300L).threadFactory(NamedThreadFactory.builder().prefix("async_delayed_executor").uncaughtExceptionHandler(LOG).build()).rejectedHandler(ThreadPoolExecutors.CALLER_RUNS).build();
        }
        this.asyncExecutor = executor;
        super.setName("async_delayed_boss-" + Integer.toHexString(this.hashCode()));
        super.setDaemon(false);
        super.setUncaughtExceptionHandler(new LoggedUncaughtExceptionHandler(LOG));
        super.start();
    }

    public boolean put(DelayedData<E> delayedData) {
        if (this.state.isStopped()) {
            return false;
        }
        return this.queue.offer(delayedData);
    }

    public boolean toStop() {
        return this.state.stop();
    }

    public void doStop() {
        this.toStop();
        Threads.stopThread(this, 2000L);
    }

    @Override
    public void run() {
        while (this.state.isRunning()) {
            DelayedData delayed;
            if (super.isInterrupted()) {
                LOG.error("Async delayed thread interrupted.");
                break;
            }
            try {
                delayed = (DelayedData)this.queue.poll(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("Delayed queue pool interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
            if (delayed == null) continue;
            Object data = delayed.getData();
            if (this.asyncExecutor != null) {
                this.asyncExecutor.submit(Throwables.ThrowingRunnable.toCaught(() -> this.dataProcessor.accept(data)));
                continue;
            }
            Throwables.ThrowingRunnable.doCaught(() -> this.dataProcessor.accept(data));
        }
        this.toStop();
        if (this.asyncExecutor != null) {
            ThreadPoolExecutors.shutdown(this.asyncExecutor, 1);
        }
    }
}

