/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

public class PeriodExecutor {
    private final long periodMs;
    private final Runnable task;
    private volatile long nextExecuteTimeMillis;

    public PeriodExecutor(long periodMs, Runnable task) {
        this.periodMs = periodMs;
        this.task = task;
        this.renewTime();
    }

    public void execute() {
        if (this.nextExecuteTimeMillis < System.currentTimeMillis()) {
            this.renewTime();
            this.task.run();
        }
    }

    private void renewTime() {
        this.nextExecuteTimeMillis = System.currentTimeMillis() + this.periodMs;
    }
}

