/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import cn.ponfee.disjob.common.concurrent.LoggedUncaughtExceptionHandler;
import cn.ponfee.disjob.common.exception.Throwables;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Threads {
    private static final Logger LOG = LoggerFactory.getLogger(Threads.class);

    public static String getName(Thread thread) {
        return thread == null ? null : thread.getName();
    }

    public static Thread newThread(String name, boolean daemon, int priority, Runnable run, Logger logger) {
        Thread thread = new Thread(run);
        thread.setName(name);
        thread.setDaemon(daemon);
        thread.setPriority(priority);
        if (logger != null) {
            thread.setUncaughtExceptionHandler(new LoggedUncaughtExceptionHandler(logger));
        }
        return thread;
    }

    public static boolean isStopped(Thread thread) {
        return thread.getState() == Thread.State.TERMINATED;
    }

    public static void stopThread(Thread thread, long joinMillis) {
        LOG.info("Stop thread start [{}]", (Object)thread.getName());
        Threads.stopThread0(thread, joinMillis);
        LOG.info("Stop thread end [{}]", (Object)thread.getName());
    }

    public static void interruptIfNecessary(Throwable t) {
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getStackFrame(int depth) {
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        return depth < traces.length ? traces[depth].toString() : null;
    }

    public static String getStackTrace() {
        return Threads.buildStackTrace(Thread.currentThread().getStackTrace());
    }

    public static String getStackTrace(Thread thread) {
        return Threads.buildStackTrace(thread.getStackTrace());
    }

    public static boolean waitUntil(int round, long[] sleepMillis, BooleanSupplier supplier) {
        return Threads.waitUntil(round, sleepMillis, true, supplier);
    }

    public static boolean waitUntil(int round, long[] sleepMillis, boolean caught, BooleanSupplier supplier) {
        int lastIndex = sleepMillis.length - 1;
        for (int i = 0; i < round; ++i) {
            long sleepTime = sleepMillis[Math.min(i, lastIndex)];
            if (sleepTime > 0L) {
                if (caught) {
                    Throwables.ThrowingRunnable.doCaught(() -> Thread.sleep(sleepTime));
                } else {
                    Throwables.ThrowingRunnable.doChecked(() -> Thread.sleep(sleepTime));
                }
            }
            if (!supplier.getAsBoolean()) continue;
            return true;
        }
        return false;
    }

    private static String buildStackTrace(StackTraceElement[] traces) {
        StringBuilder builder = new StringBuilder();
        int n = traces.length;
        for (int i = 2; i < n; ++i) {
            builder.append("\t").append(traces[i].toString()).append("\n");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private static void stopThread0(Thread thread, long joinMillis) {
        if (thread == Thread.currentThread()) {
            LOG.info("Stop self thread [{}]\n{}", (Object)thread.getName(), (Object)Threads.getStackTrace());
            return;
        }
        if (Threads.isStopped(thread)) {
            LOG.info("Thread already stopped [{}]", (Object)thread.getName());
            return;
        }
        long halfJoinMillis = joinMillis / 2L;
        if (Threads.join(thread, halfJoinMillis)) {
            return;
        }
        thread.interrupt();
        if (Threads.join(thread, halfJoinMillis)) {
            return;
        }
        try {
            LOG.warn("Invoke java.lang.Thread#stop() method begin: {}", (Object)thread.getName());
            thread.stop();
            LOG.warn("Invoke java.lang.Thread#stop() method end: {}", (Object)thread.getName());
        }
        catch (Throwable t) {
            LOG.error("Invoke java.lang.Thread#stop() method failed: " + thread.getName(), t);
        }
    }

    private static boolean join(Thread thread, long joinTimeoutMills) {
        if (joinTimeoutMills > 0L) {
            try {
                thread.join(joinTimeoutMills);
            }
            catch (Throwable e) {
                LOG.error("Join thread terminal interrupted: " + thread.getName(), e);
                Threads.interruptIfNecessary(e);
            }
        }
        return Threads.isStopped(thread);
    }
}

