/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public class TripState {
    private static final int NEW = 0;
    private static final int RUNNING = 1;
    private static final int STOPPED = 2;
    private final AtomicInteger state = new AtomicInteger(0);

    private TripState() {
    }

    public static TripState create() {
        return new TripState();
    }

    public static TripState createStarted() {
        TripState state = new TripState();
        state.start();
        return state;
    }

    public boolean isNew() {
        return this.state.get() == 0;
    }

    public boolean start() {
        return this.state.compareAndSet(0, 1);
    }

    public boolean isRunning() {
        return this.state.get() == 1;
    }

    public boolean stop() {
        return this.state.compareAndSet(1, 2);
    }

    public boolean isStopped() {
        return this.state.get() == 2;
    }

    public String toString() {
        if (this.isNew()) {
            return "New";
        }
        return this.isRunning() ? "Running" : "Stopped";
    }
}

