/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.dag;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.dag.DAGEdge;
import cn.ponfee.disjob.common.dag.DAGNode;
import cn.ponfee.disjob.common.tree.BaseNode;
import cn.ponfee.disjob.common.tree.PlainNode;
import cn.ponfee.disjob.common.tree.TreeNode;
import cn.ponfee.disjob.common.tuple.Tuple2;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.Predicates;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class DAGExpression {
    private static final Pattern JSON_ARRAY_PATTERN = Pattern.compile("(?s)^\\s*\\[\\s*\\{.+}\\s*]\\s*$");
    private static final String SEP_STAGE = "->";
    private static final String SEP_UNION = ",";
    private static final List<String> SEP_SYMBOLS = ImmutableList.of((Object)"->", (Object)",");
    private static final List<String> ALL_SYMBOLS = ImmutableList.of((Object)"->", (Object)",", (Object)")", (Object)"(");
    private static final char[] SINGLE_SYMBOLS = new char[]{'(', ')', ','};
    private final String expression;
    private final Map<String, String> wrappedCache = new IdentityHashMap<String, String>();
    private final Map<PartitionIdentityKey, String> partitionCache = new HashMap<PartitionIdentityKey, String>();
    private final Map<String, List<Tuple2<String, Integer>>> incrementer = new HashMap<String, List<Tuple2<String, Integer>>>();

    public static Graph<DAGNode> parse(String text) {
        return new DAGExpression(text).parse();
    }

    private DAGExpression(String text) {
        Assert.hasText((String)text, (String)"Expression cannot be blank.");
        this.expression = text.trim();
    }

    private Graph<DAGNode> parse() {
        List edges;
        ImmutableGraph.Builder graphBuilder = GraphBuilder.directed().allowsSelfLoops(false).immutable();
        if (JSON_ARRAY_PATTERN.matcher(this.expression).matches() && (edges = GraphEdge.fromJson(this.expression)) != null) {
            this.parseJsonGraph((ImmutableGraph.Builder<DAGNode>)graphBuilder, edges);
        } else {
            this.parsePlainExpr((ImmutableGraph.Builder<DAGNode>)graphBuilder);
        }
        ImmutableGraph graph = graphBuilder.build();
        Assert.state((graph.nodes().size() > 2 ? 1 : 0) != 0, () -> "Expression not any name: " + this.expression);
        Assert.state((boolean)graph.successors((Object)DAGNode.START).stream().noneMatch(DAGNode::isEnd), () -> "Expression name cannot direct end: " + this.expression);
        Assert.state((boolean)graph.predecessors((Object)DAGNode.END).stream().noneMatch(DAGNode::isStart), () -> "Expression name cannot direct start: " + this.expression);
        Assert.state((!Graphs.hasCycle((Graph)graph) ? 1 : 0) != 0, () -> "Expression name section has cycle: " + this.expression);
        return graph;
    }

    private void parseJsonGraph(ImmutableGraph.Builder<DAGNode> graphBuilder, List<DAGEdge> edges) {
        Assert.notEmpty(edges, (String)"Graph edges cannot be empty.");
        HashSet<DAGNode> allNode = new HashSet<DAGNode>();
        HashSet<DAGNode> nonHead = new HashSet<DAGNode>();
        HashSet<DAGNode> nonTail = new HashSet<DAGNode>();
        for (DAGEdge edge : edges) {
            DAGNode source = edge.getSource();
            DAGNode target = edge.getTarget();
            Assert.isTrue((!source.isStartOrEnd() ? 1 : 0) != 0, () -> "Graph edge cannot be start or end: " + source);
            Assert.isTrue((!target.isStartOrEnd() ? 1 : 0) != 0, () -> "Graph edge cannot be start or end: " + target);
            graphBuilder.putEdge((Object)source, (Object)target);
            allNode.add(source);
            allNode.add(target);
            nonHead.add(target);
            nonTail.add(source);
        }
        allNode.stream().filter(Predicates.not(nonHead::contains)).forEach(e -> graphBuilder.putEdge((Object)DAGNode.START, e));
        allNode.stream().filter(Predicates.not(nonTail::contains)).forEach(e -> graphBuilder.putEdge(e, (Object)DAGNode.END));
    }

    private void parsePlainExpr(ImmutableGraph.Builder<DAGNode> graphBuilder) {
        Assert.isTrue((boolean)DAGExpression.checkParenthesis(this.expression), () -> "Invalid expression parenthesis: " + this.expression);
        List sections = Stream.of(this.expression.split(";")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        Assert.notEmpty(sections, () -> "Invalid split with ';' expression: " + this.expression);
        int n = sections.size();
        for (int i = 0; i < n; ++i) {
            String section = (String)sections.get(i);
            Assert.isTrue((boolean)DAGExpression.checkParenthesis(section), () -> "Invalid expression parenthesis: " + section);
            String expr = DAGExpression.completeParenthesis(section);
            this.buildGraph(i + 1, Collections.singletonList(expr), graphBuilder, DAGNode.START, DAGNode.END);
        }
    }

    private void buildGraph(int section, List<String> expressions, ImmutableGraph.Builder<DAGNode> graphBuilder, DAGNode prev, DAGNode next) {
        Tuple2<List<String>, List<String>> tuple = DAGExpression.divideFirstStage(expressions);
        if (tuple == null) {
            return;
        }
        List first = (List)tuple.a;
        List remains = (List)tuple.b;
        int n = first.size() - 1;
        for (int i = 0; i <= n; ++i) {
            List<String> list = this.resolve((String)first.get(i));
            Assert.notEmpty(list, () -> "Invalid expression: " + String.join((CharSequence)"", expressions));
            if (list.size() == 1) {
                String name = list.get(0);
                DAGNode node = DAGNode.of(section, this.incrementOrdinal(name), name);
                graphBuilder.putEdge((Object)prev, (Object)node);
                if (remains == null) {
                    graphBuilder.putEdge((Object)node, (Object)next);
                    continue;
                }
                this.buildGraph(section, remains, graphBuilder, node, next);
                continue;
            }
            this.buildGraph(section, DAGExpression.concat(list, remains), graphBuilder, prev, next);
        }
    }

    private List<String> resolve(String text) {
        String expr = text.trim();
        if (ALL_SYMBOLS.stream().noneMatch(expr::contains)) {
            return Collections.singletonList(expr);
        }
        if (!expr.startsWith("(") || !expr.endsWith(")")) {
            return this.resolve(this.wrappedCache.computeIfAbsent(expr, DAGExpression::wrap));
        }
        List<Tuple2<Integer, Integer>> groups = DAGExpression.group(expr);
        List outermost = groups.stream().filter(e -> (Integer)e.b == 1).collect(Collectors.toList());
        if (outermost.size() != 2) {
            if (outermost.size() > 2) {
                return this.resolve(this.wrappedCache.computeIfAbsent(expr, DAGExpression::wrap));
            }
            throw new IllegalArgumentException("Invalid expression: " + expr);
        }
        Assert.isTrue(((Integer)((Tuple2)outermost.get((int)0)).a == 0 && (Integer)((Tuple2)outermost.get((int)1)).a == expr.length() - 1 ? 1 : 0) != 0, () -> "Invalid expression: " + text);
        TreeNode<TreeNodeId, Object> root = DAGExpression.buildTree(groups);
        ArrayList<Integer> list = new ArrayList<Integer>(root.getChildrenCount() * 2 + 2);
        list.add(((TreeNodeId)root.getNid()).open);
        root.forEachChild(child -> {
            list.add(((TreeNodeId)child.getNid()).open);
            list.add(((TreeNodeId)child.getNid()).close);
        });
        list.add(((TreeNodeId)root.getNid()).close);
        return this.partition(expr, list);
    }

    private List<String> partition(String expr, List<Integer> groups) {
        ArrayList<String> result = new ArrayList<String>(groups.size());
        int n = groups.size() - 1;
        for (int i = 0; i < n; ++i) {
            PartitionIdentityKey key = new PartitionIdentityKey(expr, groups.get(i) + 1, groups.get(i + 1));
            String str = this.partitionCache.computeIfAbsent(key, rec$ -> ((PartitionIdentityKey)rec$).partition());
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            result.add(str);
        }
        return result;
    }

    private int incrementOrdinal(String name) {
        List list = this.incrementer.computeIfAbsent(name, k -> new LinkedList());
        Tuple2<String, Integer> tuple = list.stream().filter(e -> name == e.a).findAny().orElse(null);
        if (tuple == null) {
            tuple = Tuple2.of(name, list.size() + 1);
            list.add(tuple);
        }
        return (Integer)tuple.b;
    }

    private static Tuple2<List<String>, List<String>> divideFirstStage(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Assert.isTrue((!SEP_SYMBOLS.contains(Collects.getFirst(list)) ? 1 : 0) != 0, () -> "Invalid expression: " + String.join((CharSequence)"", list));
        Assert.isTrue((!SEP_SYMBOLS.contains(Collects.getLast(list)) ? 1 : 0) != 0, () -> "Invalid expression: " + String.join((CharSequence)"", list));
        if (list.size() == 1) {
            return Tuple2.of(list, null);
        }
        ArrayList<String> head = new ArrayList<String>();
        int i = 0;
        int n = list.size() - 1;
        block8: while (i <= n) {
            head.add(list.get(i++));
            if (i > n) {
                return Tuple2.of(head, null);
            }
            switch (list.get(i++)) {
                case "->": {
                    return Tuple2.of(head, list.subList(i, list.size()));
                }
                case ",": {
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid expression: " + String.join((CharSequence)"", list));
        }
        return Tuple2.of(head, null);
    }

    private static TreeNode<TreeNodeId, Object> buildTree(List<Tuple2<Integer, Integer>> groups) {
        ArrayList<BaseNode<TreeNodeId, Object>> nodes = new ArrayList<BaseNode<TreeNodeId, Object>>(groups.size() + 1);
        DAGExpression.buildTree(groups, TreeNodeId.ROOT_ID, 1, 0, nodes);
        TreeNode dummyRoot = TreeNode.builder(TreeNodeId.ROOT_ID).build();
        dummyRoot.mount(nodes);
        Assert.state((dummyRoot.getChildrenCount() == 1 ? 1 : 0) != 0, (String)"Build tree root node must be has a single child.");
        return dummyRoot.getChildren().get(0);
    }

    private static void buildTree(List<Tuple2<Integer, Integer>> groups, TreeNodeId pid, int level, int start, List<BaseNode<TreeNodeId, Object>> nodes) {
        int open = -1;
        int n = groups.size();
        for (int i = start; i < n; ++i) {
            if ((Integer)groups.get((int)i).b < level) {
                return;
            }
            if ((Integer)groups.get((int)i).b != level) continue;
            if (open == -1) {
                open = i;
                continue;
            }
            TreeNodeId nid = TreeNodeId.of((Integer)groups.get((int)open).a, (Integer)groups.get((int)i).a);
            nodes.add(new PlainNode<TreeNodeId, Object>(nid, pid, null));
            DAGExpression.buildTree(groups, nid, level + 1, open + 1, nodes);
            open = -1;
        }
    }

    private static List<String> concat(List<String> left, List<String> right) {
        if (CollectionUtils.isEmpty(right)) {
            return left;
        }
        ArrayList<String> result = new ArrayList<String>(left.size() + 1 + right.size());
        result.addAll(left);
        result.add(SEP_STAGE);
        result.addAll(right);
        return result;
    }

    private static boolean checkParenthesis(String text) {
        int openCount = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (c == '(') {
                ++openCount;
            } else if (c == ')') {
                --openCount;
            }
            if (openCount >= 0) continue;
            return false;
        }
        return openCount == 0;
    }

    private static String completeParenthesis(String text) {
        ArrayList<String> list = new ArrayList<String>();
        int mark = 0;
        int position = 0;
        int len = text.length() - 1;
        while (position <= len) {
            char ch;
            Assert.isTrue(((ch = text.charAt(position++)) != '>' ? 1 : 0) != 0, () -> "Invalid '" + ch + "': " + text);
            if (ArrayUtils.contains((char[])SINGLE_SYMBOLS, (char)ch)) {
                list.add(text.substring(mark, position - 1).trim());
                list.add(Character.toString(ch));
                mark = position;
                continue;
            }
            if (ch != '-') continue;
            Assert.isTrue((position <= len && text.charAt(position) == '>' ? 1 : 0) != 0, () -> "Invalid '->' :" + text);
            list.add(text.substring(mark, position - 1).trim());
            list.add(SEP_STAGE);
            mark = ++position;
        }
        if (position > mark) {
            list.add(text.substring(mark, position).trim());
        }
        StringBuilder builder = new StringBuilder();
        int n = list.size() - 1;
        for (int i = 0; i <= n; ++i) {
            String item = (String)list.get(i);
            if (StringUtils.isBlank((CharSequence)item)) continue;
            if (ALL_SYMBOLS.contains(item)) {
                builder.append(item);
                continue;
            }
            if ("(".equals(Collects.get(list, i - 1)) && ")".equals(Collects.get(list, i + 1))) {
                builder.append(item);
                continue;
            }
            builder.append("(").append(item).append(")");
        }
        return builder.toString();
    }

    private static List<Tuple2<Integer, Integer>> group(String expr) {
        Assert.isTrue((boolean)DAGExpression.checkParenthesis(expr), () -> "Invalid expression parenthesis: " + expr);
        int depth = 0;
        ArrayList<Tuple2<Integer, Integer>> list = new ArrayList<Tuple2<Integer, Integer>>();
        int n = expr.length();
        for (int i = 0; i < n; ++i) {
            if (expr.charAt(i) == '(') {
                if (++depth > 2) continue;
                list.add(Tuple2.of(i, depth));
                continue;
            }
            if (expr.charAt(i) != ')') continue;
            if (depth <= 2) {
                list.add(Tuple2.of(i, depth));
            }
            --depth;
        }
        Assert.isTrue(((list.size() & 1) == 0 ? 1 : 0) != 0, () -> "Expression not pair with '()': " + expr);
        return list;
    }

    private static String wrap(String text) {
        return "(" + text + ")";
    }

    private static final class PartitionIdentityKey {
        private final String expr;
        private final int open;
        private final int close;

        private PartitionIdentityKey(String expr, int open, int close) {
            Assert.hasText((String)expr, () -> "Partition expression cannot be blank: " + expr);
            Assert.isTrue((open > -1 ? 1 : 0) != 0, () -> "Partition key open must be greater than -1: " + open);
            Assert.isTrue((close > 0 ? 1 : 0) != 0, () -> "Partition key close must be greater than 0: " + close);
            this.expr = expr;
            this.open = open;
            this.close = close;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionIdentityKey)) {
                return false;
            }
            PartitionIdentityKey that = (PartitionIdentityKey)obj;
            return this.expr == that.expr && this.open == that.open && this.close == that.close;
        }

        public int hashCode() {
            return System.identityHashCode(this.expr) + this.open + this.close;
        }

        private String partition() {
            return this.expr.substring(this.open, this.close).trim();
        }
    }

    private static final class TreeNodeId
    implements Serializable,
    Comparable<TreeNodeId> {
        private static final long serialVersionUID = -468548698179536500L;
        private static final TreeNodeId ROOT_ID = new TreeNodeId(-1, -1);
        private final int open;
        private final int close;

        private TreeNodeId(int open, int close) {
            this.open = open;
            this.close = close;
        }

        private static TreeNodeId of(int open, int close) {
            Assert.isTrue((open > -1 ? 1 : 0) != 0, () -> "Tree node id open must be greater than -1: " + open);
            Assert.isTrue((close > 0 ? 1 : 0) != 0, () -> "Tree node id close must be greater than 0: " + close);
            return new TreeNodeId(open, close);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TreeNodeId)) {
                return false;
            }
            TreeNodeId that = (TreeNodeId)obj;
            return this.open == that.open && this.close == that.close;
        }

        public int hashCode() {
            return this.open + this.close;
        }

        @Override
        public int compareTo(TreeNodeId other) {
            int n = this.open - other.open;
            return n != 0 ? n : this.close - other.close;
        }

        public String toString() {
            return "(" + this.open + DAGExpression.SEP_UNION + this.close + ")";
        }
    }

    private static final class GraphEdge {
        private static final TypeReference<List<GraphEdge>> LIST_TYPE = new TypeReference<List<GraphEdge>>(){};
        private String source;
        private String target;

        private GraphEdge() {
        }

        private DAGEdge toDAGEdge() {
            return DAGEdge.of(this.source, this.target);
        }

        private static List<DAGEdge> fromJson(String text) {
            try {
                List<GraphEdge> list = Jsons.fromJson(text, LIST_TYPE);
                if (CollectionUtils.isEmpty(list)) {
                    return null;
                }
                return list.stream().map(GraphEdge::toDAGEdge).collect(Collectors.toList());
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }
}

