/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.dag;

import cn.ponfee.disjob.common.base.TextTokenizer;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.Assert;

public final class DAGNode
implements Serializable {
    private static final long serialVersionUID = 7413110685194391605L;
    public static final DAGNode START = new DAGNode(0, 0, "Start");
    public static final DAGNode END = new DAGNode(0, 0, "End");
    private final int section;
    private final int ordinal;
    private final String name;

    private DAGNode(int section, int ordinal, String name) {
        this.section = section;
        this.ordinal = ordinal;
        this.name = name;
    }

    public static DAGNode of(int section, int ordinal, String name) {
        Assert.isTrue((section > 0 ? 1 : 0) != 0, () -> "Graph node section must be greater than 0: " + section);
        Assert.isTrue((ordinal > 0 ? 1 : 0) != 0, () -> "Graph node ordinal must be greater than 0: " + ordinal);
        Assert.hasText((String)name, () -> "Graph node name cannot be blank: " + name);
        return new DAGNode(section, ordinal, name);
    }

    public int getSection() {
        return this.section;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    @Transient
    public boolean isStart() {
        return this.equals(START);
    }

    @Transient
    public boolean isEnd() {
        return this.equals(END);
    }

    @Transient
    public boolean isStartOrEnd() {
        return this.isStart() || this.isEnd();
    }

    public int hashCode() {
        return Objects.hash(this.section, this.ordinal, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DAGNode)) {
            return false;
        }
        DAGNode other = (DAGNode)obj;
        return this.section == other.section && this.ordinal == other.ordinal && this.name.equals(other.name);
    }

    public boolean equals(int section, int ordinal, String name) {
        return this.section == section && this.ordinal == ordinal && this.name.equals(name);
    }

    public String toString() {
        return this.section + ":" + this.ordinal + ":" + this.name;
    }

    public static DAGNode fromString(String str) {
        String name;
        int ordinal;
        TextTokenizer tokenizer = new TextTokenizer(str, ":");
        int section = Integer.parseInt(tokenizer.next());
        if (START.equals(section, ordinal = Integer.parseInt(tokenizer.next()), name = tokenizer.tail())) {
            return START;
        }
        if (END.equals(section, ordinal, name)) {
            return END;
        }
        return DAGNode.of(section, ordinal, name);
    }
}

