/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.dag;

import cn.ponfee.disjob.common.dag.DAGExpression;
import cn.ponfee.disjob.common.dag.DAGNode;
import com.google.common.graph.EndpointPair;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.GraphAttr;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.Node;
import java.io.IOException;
import java.io.OutputStream;

public class DAGUtils {
    public static void drawPngImage(String expression, String name, int width, OutputStream output) throws IOException {
        MutableGraph graph = Factory.mutGraph((String)name).setDirected(true);
        graph.graphAttrs().add((Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.LEFT_TO_RIGHT));
        graph.graphAttrs().add(GraphAttr.splines((GraphAttr.SplineMode)GraphAttr.SplineMode.CURVED));
        graph.graphAttrs().add(GraphAttr.splines((GraphAttr.SplineMode)GraphAttr.SplineMode.CURVED));
        for (EndpointPair edge : DAGExpression.parse(expression).edges()) {
            DAGNode s = (DAGNode)edge.source();
            DAGNode t = (DAGNode)edge.target();
            Node source = (Node)Factory.node((String)s.toString()).with((Attributes)(s.isStart() ? Shape.M_DIAMOND : Shape.RECTANGLE), (Attributes)Label.of((String)s.getName()));
            Node target = (Node)Factory.node((String)t.toString()).with((Attributes)(t.isEnd() ? Shape.M_SQUARE : Shape.RECTANGLE), (Attributes)Label.of((String)t.getName()));
            graph.add((LinkSource)source.link(new LinkTarget[]{target}));
        }
        Graphviz.fromGraph((MutableGraph)graph).width(width).render(Format.PNG).toOutputStream(output);
    }
}

