/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.lock;

import cn.ponfee.disjob.common.base.RetryTemplate;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.lock.LockTemplate;
import cn.ponfee.disjob.common.spring.JdbcTemplateWrapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public final class DatabaseLockTemplate
implements LockTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseLockTemplate.class);
    private static final String TABLE_NAME = "sched_lock";
    private static final String CREATE_TABLE_DDL = "CREATE TABLE IF NOT EXISTS `sched_lock` (                                                      \n  `id`    BIGINT       UNSIGNED  NOT NULL  AUTO_INCREMENT  COMMENT 'auto increment primary key id',    \n  `name`  VARCHAR(60)            NOT NULL                  COMMENT 'lock name',                        \n  PRIMARY KEY (`id`),                                                                                  \n  UNIQUE KEY `uk_name` (`name`)                                                                        \n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='Distributed lock based database'; \n";
    private static final String INSERT_SQL = "INSERT INTO sched_lock (name) VALUES (?)";
    private static final String GET_SQL = "SELECT 1 FROM sched_lock WHERE name=?";
    private static final String LOCK_SQL = "SELECT 1 FROM sched_lock WHERE name=? FOR UPDATE";
    private final JdbcTemplateWrapper jdbcTemplateWrapper;
    private final String lockName;

    public DatabaseLockTemplate(JdbcTemplate jdbcTemplate, String lockName) {
        this.jdbcTemplateWrapper = JdbcTemplateWrapper.of(jdbcTemplate);
        this.lockName = lockName;
        this.jdbcTemplateWrapper.createTableIfNotExists(TABLE_NAME, CREATE_TABLE_DDL);
        try {
            RetryTemplate.execute(this::initializeLockIfNecessary, 3, 1000L);
        }
        catch (Throwable e) {
            Threads.interruptIfNecessary(e);
            throw new Error("Initialize lock '" + lockName + "' failed.", e);
        }
    }

    @Override
    public <T> T execute(Callable<T> action) {
        return (T)this.jdbcTemplateWrapper.executeInTransaction(psCreator -> {
            PreparedStatement preparedStatement = (PreparedStatement)psCreator.apply(LOCK_SQL);
            preparedStatement.setString(1, this.lockName);
            ResultSet rs = preparedStatement.executeQuery();
            Assert.state((rs.next() && rs.getInt(1) == 1 ? 1 : 0) != 0, () -> "Lock Not found '" + this.lockName + "'.");
            Object result = action.call();
            JdbcUtils.closeResultSet((ResultSet)rs);
            return result;
        });
    }

    private void initializeLockIfNecessary() {
        if (this.getLockId() != null) {
            return;
        }
        try {
            this.jdbcTemplateWrapper.insert(INSERT_SQL, this.lockName);
        }
        catch (DuplicateKeyException e) {
            LOG.info("Lock name '{}' already exists: {}", (Object)this.lockName, (Object)e.getMessage());
        }
        Objects.requireNonNull(this.getLockId());
    }

    private Integer getLockId() {
        return this.jdbcTemplateWrapper.get(GET_SQL, JdbcTemplateWrapper.INTEGER_ROW_MAPPER, this.lockName);
    }
}

