/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.lock;

import cn.ponfee.disjob.common.spring.RedisTemplateUtils;
import cn.ponfee.disjob.common.util.Bytes;
import cn.ponfee.disjob.common.util.UuidUtils;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.Assert;

public class RedisLock
implements Lock,
Serializable {
    private static final long serialVersionUID = -5820879641400425639L;
    private static final Logger LOG = LoggerFactory.getLogger(RedisLock.class);
    private static final RedisScript<Long> LOCK_SCRIPT = RedisScript.of((String)"if (    redis.call('exists',  KEYS[1]         )==0        \n     or redis.call('hexists', KEYS[1], ARGV[2])==1 ) then \n  redis.call('hincrby', KEYS[1], ARGV[2], 1);             \n  redis.call('pexpire', KEYS[1], ARGV[1]);                \n  return nil;                                             \nend;                                                      \nreturn redis.call('pttl', KEYS[1]);                       \n", Long.class);
    private static final RedisScript<Long> UNLOCK_SCRIPT = RedisScript.of((String)"if (redis.call('hexists', KEYS[1], ARGV[2]) == 0) then  \n  return nil;                                           \nend;                                                    \nlocal cnt = redis.call('hincrby', KEYS[1], ARGV[2], -1) \nif (cnt > 0) then                                       \n  redis.call('pexpire', KEYS[1], ARGV[1]);              \n  return 0;                                             \nelse                                                    \n  redis.call('del', KEYS[1]);                           \n  return 1;                                             \nend;                                                    \n", Long.class);
    private static final RedisScript<Long> RENEW_SCRIPT = RedisScript.of((String)"if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then \n  redis.call('pexpire', KEYS[1], ARGV[1]);             \n  return 1;                                            \nend;                                                   \nreturn 0;                                              \n", Long.class);
    private final transient RedisTemplate<?, ?> redisTemplate;
    private final byte[] lockKey;
    private final byte[] lockUuid;
    private final byte[] timeoutMillis;
    private final long sleepMillis;

    RedisLock(RedisTemplate<?, ?> redisTemplate, String lockKey, long timeoutMillis, long sleepMillis) {
        Assert.notNull(redisTemplate, (String)"Redis template cannot be null.");
        Assert.hasText((String)lockKey, (String)"Lock key cannot be empty.");
        long sleepMillis0 = Math.max(sleepMillis, 50L);
        long timeoutMillis0 = Math.max(sleepMillis0, timeoutMillis);
        this.redisTemplate = redisTemplate;
        this.lockKey = ("lock:" + lockKey).getBytes(StandardCharsets.UTF_8);
        this.lockUuid = UuidUtils.uuid();
        this.timeoutMillis = Long.toString(timeoutMillis0).getBytes(StandardCharsets.UTF_8);
        this.sleepMillis = sleepMillis0;
    }

    @Override
    public void lock() {
        int round = 0;
        while (!this.acquire()) {
            try {
                Thread.sleep(this.computeSleepMillis(round));
            }
            catch (InterruptedException e) {
                LOG.error("Redis lock sleep occur interrupted exception.", (Throwable)e);
                ExceptionUtils.rethrow((Throwable)e);
            }
            ++round;
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        int round = 0;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.acquire()) break;
            Thread.sleep(this.computeSleepMillis(round));
            ++round;
        }
    }

    @Override
    public boolean tryLock() {
        return this.acquire();
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        long end = System.nanoTime() + unit.toNanos(timeout);
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.acquire()) {
                return true;
            }
            if (end < System.nanoTime()) {
                return false;
            }
            Thread.sleep(this.sleepMillis);
        }
    }

    @Override
    public void unlock() {
        this.release();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Unsupported new condition operation.");
    }

    public boolean isHeldByCurrentThread() {
        return this.redisTemplate.execute(conn -> conn.hGet(this.lockKey, this.getLockValue())) != null;
    }

    public boolean isLocked() {
        Boolean res = (Boolean)this.redisTemplate.execute(conn -> conn.exists(this.lockKey));
        return res != null && res != false;
    }

    public void forceUnlock() {
        this.redisTemplate.execute(conn -> conn.del((byte[][])new byte[][]{this.lockKey}));
    }

    private boolean acquire() {
        byte[][] keysAndArgs = new byte[][]{this.lockKey, this.timeoutMillis, this.getLockValue()};
        Long ret = RedisTemplateUtils.evalScript(this.redisTemplate, LOCK_SCRIPT, 1, (byte[][])keysAndArgs);
        return ret == null;
    }

    private boolean release() {
        byte[][] keysAndArgs = new byte[][]{this.lockKey, this.timeoutMillis, this.getLockValue()};
        Long ret = RedisTemplateUtils.evalScript(this.redisTemplate, UNLOCK_SCRIPT, 1, (byte[][])keysAndArgs);
        return ret != null && ret == 1L;
    }

    private byte[] getLockValue() {
        return Bytes.concat(this.lockUuid, Bytes.toBytes(Thread.currentThread().getId()));
    }

    private long computeSleepMillis(int round) {
        return round < 5 ? this.sleepMillis : Math.min(this.sleepMillis * (long)(round - 3), 2000L);
    }
}

