/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.model;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.model.CodeMsg;
import java.beans.Transient;
import java.io.Serializable;
import java.util.function.Function;

public class Result<T>
extends ToJsonString
implements CodeMsg,
Serializable {
    private static final long serialVersionUID = -7637967889181161801L;
    private Integer code;
    private String msg;
    private T data;

    public Result() {
    }

    public Result(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public <E> Result<E> cast() {
        return this;
    }

    public <E> Result<E> map(Function<T, E> mapper) {
        return new Result<E>(this.code, this.msg, mapper.apply(this.data));
    }

    public static Result<Void> success() {
        return SuccessResult.INSTANCE;
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(0, "OK", data);
    }

    public static <T> Result<T> failure(CodeMsg cm) {
        return Result.failure(cm.getCode(), cm.getMsg());
    }

    public static <T> Result<T> failure(int code) {
        return Result.failure(code, null);
    }

    public static <T> Result<T> failure(int code, String msg) {
        if (code == 0) {
            throw new IllegalStateException("Result failure code '" + code + "' cannot be '" + 0 + "'.");
        }
        return new Result<Object>(code, msg, null);
    }

    public static <T> Result<T> of(CodeMsg cm) {
        return new Result<Object>(cm.getCode(), cm.getMsg(), null);
    }

    public static <T> Result<T> of(CodeMsg cm, T data) {
        return new Result<T>(cm.getCode(), cm.getMsg(), data);
    }

    public static <T> Result<T> of(int code, String msg) {
        return new Result<Object>(code, msg, null);
    }

    public static <T> Result<T> of(int code, String msg, T data) {
        return new Result<T>(code, msg, data);
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Transient
    public boolean isSuccess() {
        return this.code != null && this.code == 0;
    }

    @Transient
    public boolean isFailure() {
        return !this.isSuccess();
    }

    private static final class SuccessResult
    extends ImmutableResult<Void> {
        private static final long serialVersionUID = -8356385235924100622L;
        private static final int CODE = 0;
        private static final String MSG = "OK";
        public static final Result<Void> INSTANCE = new SuccessResult();

        private SuccessResult() {
            super(0, MSG, null);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static abstract class ImmutableResult<T>
    extends Result<T> {
        private static final long serialVersionUID = -8356385235924100622L;

        protected ImmutableResult(int code, String msg, T data) {
            super(code, msg, data);
        }

        @Override
        public final void setCode(int code) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setMsg(String msg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setData(T data) {
            throw new UnsupportedOperationException();
        }
    }
}

