/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.date.JavaUtilDateFormat;
import cn.ponfee.disjob.common.util.Jsons;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.DateFormat;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@Import(value={JacksonDateConfiguration.class})
public @interface JacksonDateConfigurer {

    public static class JacksonDateConfiguration {
        public JacksonDateConfiguration(@Nullable ObjectMapper objectMapper) {
            if (objectMapper == null) {
                return;
            }
            objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
            objectMapper.setDateFormat((DateFormat)JavaUtilDateFormat.DEFAULT);
            Jsons.registerSimpleModule(objectMapper);
            Jsons.registerJavaTimeModule(objectMapper);
            objectMapper.registerModule((Module)new Jdk8Module());
        }
    }
}

