/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.spring.SpringUtils;
import cn.ponfee.disjob.common.util.Strings;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@Import(value={MybatisDataSourceRegistrar.class})
public @interface MybatisDataSourceConfigurer {
    public static final String DATA_SOURCE_NAME_SUFFIX = "DataSource";
    public static final String SQL_SESSION_FACTORY_NAME_SUFFIX = "SqlSessionFactory";
    public static final String SQL_SESSION_TEMPLATE_NAME_SUFFIX = "SqlSessionTemplate";
    public static final String TX_MANAGER_NAME_SUFFIX = "TransactionManager";
    public static final String TX_TEMPLATE_NAME_SUFFIX = "TransactionTemplate";
    public static final String JDBC_TEMPLATE_NAME_SUFFIX = "JdbcTemplate";
    public static final String MAPPER_SCANNER_CONFIGURER_NAME_SUFFIX = "MapperScannerConfigurer";

    public String dataSourceName() default "";

    public String[] mapperLocations() default {};

    public String[] basePackages() default {};

    public Class<?>[] basePackageClasses() default {};

    public boolean mapUnderscoreToCamelCase() default true;

    public int defaultFetchSize() default 100;

    public int defaultStatementTimeout() default 25;

    public boolean primary() default false;

    public static class MybatisDataSourceRegistrar
    implements ImportBeanDefinitionRegistrar {
        private static final Logger LOG = LoggerFactory.getLogger(MybatisDataSourceRegistrar.class);
        private static final String KEY_PREFIX = "disjob.datasource.";
        private final Environment environment;

        MybatisDataSourceRegistrar(Environment environment) {
            this.environment = environment;
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            MybatisDataSourceConfigurer config = SpringUtils.parseAnnotation(MybatisDataSourceConfigurer.class, (AnnotatedTypeMetadata)importingClassMetadata);
            if (config == null) {
                throw new IllegalArgumentException("MybatisDataSourceConfigurer cannot be null.");
            }
            List<String> basePackages = MybatisDataSourceRegistrar.resolveBasePackages(config, importingClassMetadata);
            Assert.notEmpty(basePackages, (String)"Base package is empty.");
            String dataSourceName = config.dataSourceName();
            if (StringUtils.isBlank((CharSequence)dataSourceName)) {
                dataSourceName = MybatisDataSourceRegistrar.resolvePackageDatasourceName(basePackages.get(0));
            }
            Assert.hasText((String)dataSourceName, (String)"DataSource name cannot be empty.");
            String dataSourceConfigPrefixKey = KEY_PREFIX + dataSourceName;
            String jdbcUrl = this.environment.getProperty(dataSourceConfigPrefixKey + ".jdbc-url");
            if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
                LOG.warn("Datasource '{}' not configured jdbc-url value.", (Object)dataSourceName);
                return;
            }
            SpringUtils.addPropertyIfAbsent(this.environment, dataSourceConfigPrefixKey + ".pool-name", dataSourceName);
            boolean primary = config.primary();
            BeanDefinitionBuilder mapperScannerConfigurerBdb = this.newBeanDefinitionBuilder(MapperScannerConfigurer.class, primary);
            mapperScannerConfigurerBdb.addPropertyValue("processPropertyPlaceHolders", (Object)true);
            mapperScannerConfigurerBdb.addPropertyValue("basePackage", (Object)String.join((CharSequence)",", basePackages));
            mapperScannerConfigurerBdb.addPropertyValue("sqlSessionTemplateBeanName", (Object)(dataSourceName + MybatisDataSourceConfigurer.SQL_SESSION_TEMPLATE_NAME_SUFFIX));
            registry.registerBeanDefinition(dataSourceName + MybatisDataSourceConfigurer.MAPPER_SCANNER_CONFIGURER_NAME_SUFFIX, (BeanDefinition)mapperScannerConfigurerBdb.getBeanDefinition());
            BeanDefinitionBuilder dataSourceBdb = this.newBeanDefinitionBuilder(DataSource.class, primary);
            AbstractBeanDefinition dataSourceBd = dataSourceBdb.getBeanDefinition();
            dataSourceBd.setInstanceSupplier(() -> {
                Binder binder = Binder.get((Environment)this.environment);
                DataSource dataSource = DataSourceBuilder.create().build();
                binder.bind(dataSourceConfigPrefixKey, Bindable.ofInstance((Object)dataSource));
                return dataSource;
            });
            registry.registerBeanDefinition(dataSourceName + MybatisDataSourceConfigurer.DATA_SOURCE_NAME_SUFFIX, (BeanDefinition)dataSourceBd);
            BeanDefinitionBuilder sqlSessionFactoryBeanBdb = this.newBeanDefinitionBuilder(SqlSessionFactoryBean.class, primary);
            sqlSessionFactoryBeanBdb.addPropertyReference("dataSource", dataSourceName + MybatisDataSourceConfigurer.DATA_SOURCE_NAME_SUFFIX);
            sqlSessionFactoryBeanBdb.addPropertyValue("configuration", (Object)MybatisDataSourceRegistrar.createMybatisConfiguration(config));
            sqlSessionFactoryBeanBdb.addPropertyValue("mapperLocations", (Object)MybatisDataSourceRegistrar.resolveMapperLocations(config, basePackages));
            registry.registerBeanDefinition(dataSourceName + MybatisDataSourceConfigurer.SQL_SESSION_FACTORY_NAME_SUFFIX, (BeanDefinition)sqlSessionFactoryBeanBdb.getBeanDefinition());
            BeanDefinitionBuilder sqlSessionTemplateBdb = this.newBeanDefinitionBuilder(SqlSessionTemplate.class, primary);
            sqlSessionTemplateBdb.addConstructorArgReference(dataSourceName + MybatisDataSourceConfigurer.SQL_SESSION_FACTORY_NAME_SUFFIX);
            registry.registerBeanDefinition(dataSourceName + MybatisDataSourceConfigurer.SQL_SESSION_TEMPLATE_NAME_SUFFIX, (BeanDefinition)sqlSessionTemplateBdb.getBeanDefinition());
            BeanDefinitionBuilder jdbcTemplateBdb = this.newBeanDefinitionBuilder(JdbcTemplate.class, primary);
            jdbcTemplateBdb.addConstructorArgReference(dataSourceName + MybatisDataSourceConfigurer.DATA_SOURCE_NAME_SUFFIX);
            registry.registerBeanDefinition(dataSourceName + MybatisDataSourceConfigurer.JDBC_TEMPLATE_NAME_SUFFIX, (BeanDefinition)jdbcTemplateBdb.getBeanDefinition());
            BeanDefinitionBuilder dataSourceTransactionManagerBdb = this.newBeanDefinitionBuilder(DataSourceTransactionManager.class, primary);
            dataSourceTransactionManagerBdb.addConstructorArgReference(dataSourceName + MybatisDataSourceConfigurer.DATA_SOURCE_NAME_SUFFIX);
            registry.registerBeanDefinition(dataSourceName + MybatisDataSourceConfigurer.TX_MANAGER_NAME_SUFFIX, (BeanDefinition)dataSourceTransactionManagerBdb.getBeanDefinition());
            BeanDefinitionBuilder transactionTemplateBdb = this.newBeanDefinitionBuilder(TransactionTemplate.class, primary);
            transactionTemplateBdb.addConstructorArgReference(dataSourceName + MybatisDataSourceConfigurer.TX_MANAGER_NAME_SUFFIX);
            registry.registerBeanDefinition(dataSourceName + MybatisDataSourceConfigurer.TX_TEMPLATE_NAME_SUFFIX, (BeanDefinition)transactionTemplateBdb.getBeanDefinition());
            LOG.info("Datasource '{}' registered bean definition.", (Object)dataSourceName);
        }

        public static void checkPackageDatasourceName(Class<?> basePackageClass, String expectDsName) {
            String actualDsName = MybatisDataSourceRegistrar.resolvePackageDatasourceName(ClassUtils.getPackageName(basePackageClass));
            if (!actualDsName.equals(expectDsName)) {
                throw new IllegalStateException("Invalid data source name: expect=" + expectDsName + ", actual=" + actualDsName);
            }
        }

        private BeanDefinitionBuilder newBeanDefinitionBuilder(Class<?> beanType, boolean primary) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(beanType);
            builder.setPrimary(primary);
            builder.setRole(2);
            return builder;
        }

        private static String resolvePackageDatasourceName(String packageName) {
            String packageLastName = Strings.substringAfterLast(packageName, ".");
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, packageLastName);
        }

        private static List<String> resolveBasePackages(MybatisDataSourceConfigurer config, AnnotationMetadata importingClassMetadata) {
            ArrayList<String> basePackages = Collects.asArrayList(config.basePackages());
            Arrays.stream(config.basePackageClasses()).map(ClassUtils::getPackageName).forEach(basePackages::add);
            if (basePackages.isEmpty()) {
                basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
            }
            return (List)basePackages.stream().filter(StringUtils::isNotBlank).collect(ImmutableList.toImmutableList());
        }

        private static Resource[] resolveMapperLocations(MybatisDataSourceConfigurer config, List<String> basePackages) {
            Object[] mapperLocations = config.mapperLocations();
            if (ArrayUtils.isEmpty((Object[])mapperLocations)) {
                mapperLocations = (String[])basePackages.stream().map(e -> "classpath*:" + e.replace('.', '/') + "/**/*.xml").toArray(String[]::new);
            }
            try {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                for (Object mapperLocation : mapperLocations) {
                    resources.addAll(Arrays.asList(new PathMatchingResourcePatternResolver().getResources((String)mapperLocation)));
                }
                return resources.toArray(new Resource[0]);
            }
            catch (IOException e2) {
                String msg = Arrays.toString(mapperLocations);
                throw new BeanInstantiationException(SqlSessionFactory.class, "Load mybatis mapper locations error: " + msg, (Throwable)e2);
            }
        }

        private static Configuration createMybatisConfiguration(MybatisDataSourceConfigurer config) {
            VFS.addImplClass(SpringBootVFS.class);
            Configuration configuration = new Configuration();
            configuration.setMapUnderscoreToCamelCase(config.mapUnderscoreToCamelCase());
            configuration.setDefaultFetchSize(Integer.valueOf(config.defaultFetchSize()));
            configuration.setDefaultStatementTimeout(Integer.valueOf(config.defaultStatementTimeout()));
            return configuration;
        }
    }
}

