/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.common.spring.RpcControllerUtils;
import cn.ponfee.disjob.common.util.Jsons;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestTemplateUtils {
    public static final Set<HttpMethod> QUERY_PARAM_METHODS = ImmutableSet.of((Object)HttpMethod.GET, (Object)HttpMethod.HEAD, (Object)HttpMethod.OPTIONS, (Object)HttpMethod.TRACE);
    public static final Type RESULT_STRING = new ParameterizedTypeReference<Result<String>>(){}.getType();
    public static final Type RESULT_BOOLEAN = new ParameterizedTypeReference<Result<Boolean>>(){}.getType();
    public static final Type RESULT_VOID = new ParameterizedTypeReference<Result<Void>>(){}.getType();

    public static RestTemplate create(int connectTimeout, int readTimeout, ObjectMapper objectMapper) {
        return RestTemplateUtils.create(connectTimeout, readTimeout, objectMapper, StandardCharsets.UTF_8);
    }

    public static RestTemplate create(int connectTimeout, int readTimeout, ObjectMapper objectMapper, Charset charset) {
        return RestTemplateUtils.create(connectTimeout, readTimeout, RestTemplateUtils.createMappingJackson2HttpMessageConverter(objectMapper), charset);
    }

    public static RestTemplate create(int connectTimeout, int readTimeout, MappingJackson2HttpMessageConverter messageConverter, Charset charset) {
        SSLContext sslContext;
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        requestFactory.setConnectTimeout(connectTimeout);
        requestFactory.setReadTimeout(readTimeout);
        requestFactory.setHttpContextFactory((BiFunction)new HttpContextFactory());
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.setMessageConverters(Arrays.asList(new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter(charset), new ResourceHttpMessageConverter(), new SourceHttpMessageConverter(), new FormHttpMessageConverter(), messageConverter));
        return restTemplate;
    }

    public static MappingJackson2HttpMessageConverter createMappingJackson2HttpMessageConverter(@Nullable ObjectMapper objectMapper) {
        if (objectMapper == null) {
            objectMapper = Jsons.createObjectMapper(JsonInclude.Include.NON_NULL);
        }
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper(objectMapper);
        RestTemplateUtils.extendSupportedMediaTypes(messageConverter);
        return messageConverter;
    }

    public static void extendSupportedMediaTypes(MappingJackson2HttpMessageConverter converter) {
        List<MediaType> supportedMediaTypes = Collects.concat(converter.getSupportedMediaTypes(), MediaType.TEXT_PLAIN, MediaType.TEXT_HTML, MediaType.MULTIPART_FORM_DATA, MediaType.ALL);
        converter.setSupportedMediaTypes(supportedMediaTypes);
    }

    public static MultiValueMap<String, String> convertToMultiValueMap(Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        Map<String, List> map = params.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey())) && ObjectUtils.isNotEmpty(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> RestTemplateUtils.toListString(e.getValue())));
        return MapUtils.isEmpty(map) ? null : new LinkedMultiValueMap(map);
    }

    public static <T> T invoke(RestTemplate restTemplate, String url, HttpMethod httpMethod, Type returnType, Map<String, String> headersMap, Object ... arguments) {
        URI uri;
        HttpHeaders headers = new HttpHeaders();
        if (MapUtils.isNotEmpty(headersMap)) {
            headersMap.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).set(arg_0, arg_1));
        }
        if (QUERY_PARAM_METHODS.contains(httpMethod)) {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
            if (ArrayUtils.isNotEmpty((Object[])arguments)) {
                builder.queryParams(RpcControllerUtils.buildQueryParameters(arguments));
            }
            uri = builder.build().encode().toUri();
            arguments = null;
        } else {
            uri = restTemplate.getUriTemplateHandler().expand(url, Collects.EMPTY_OBJECT_ARRAY);
            if (ArrayUtils.isNotEmpty((Object[])arguments)) {
                headers.setContentType(MediaType.APPLICATION_JSON);
            }
        }
        RequestCallback requestCallback = restTemplate.httpEntityCallback((Object)new HttpEntity((Object)arguments, (MultiValueMap)headers), returnType);
        ResponseExtractor responseExtractor = restTemplate.responseEntityExtractor(returnType);
        ResponseEntity responseEntity = (ResponseEntity)restTemplate.execute(uri, httpMethod, requestCallback, responseExtractor);
        return (T)Objects.requireNonNull(responseEntity).getBody();
    }

    private static List<String> toListString(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                list.add(RestTemplateUtils.toString(Array.get(value, i)));
            }
            return list;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return coll.isEmpty() ? null : coll.stream().map(RestTemplateUtils::toString).collect(Collectors.toList());
        }
        return Collections.singletonList(RestTemplateUtils.toString(value));
    }

    private static String toString(Object value) {
        return value == null ? null : value.toString();
    }

    private static class HttpContextFactory
    implements BiFunction<HttpMethod, URI, HttpContext> {
        private HttpContextFactory() {
        }

        @Override
        public HttpContext apply(HttpMethod httpMethod, URI uri) {
            RequestConfig requestConfig = HttpContextHolder.get();
            if (requestConfig == null) {
                return null;
            }
            HttpClientContext context = HttpClientContext.create();
            context.setAttribute("http.request-config", (Object)requestConfig);
            return context;
        }
    }

    public static class HttpContextHolder {
        private static final ThreadLocal<RequestConfig> THREAD_LOCAL = new NamedThreadLocal("request-config");

        public static void bind(RequestConfig requestConfig) {
            THREAD_LOCAL.set(requestConfig);
        }

        private static RequestConfig get() {
            return THREAD_LOCAL.get();
        }

        public static void unbind() {
            THREAD_LOCAL.remove();
        }
    }
}

