/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.spring.RestTemplateUtils;
import cn.ponfee.disjob.common.spring.RpcController;
import cn.ponfee.disjob.common.spring.RpcControllerUtils;
import cn.ponfee.disjob.common.util.Jsons;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class RpcControllerConfigurer
implements WebMvcConfigurer {
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new RpcControllerArgumentResolver());
    }

    private static class RpcControllerArgumentResolver
    implements HandlerMethodArgumentResolver {
        static final Set<String> QUERY_PARAM_METHODS = Collects.convert(RestTemplateUtils.QUERY_PARAM_METHODS, Enum::name);
        static final String CACHE_ATTRIBUTE_KEY = "$disjob$RpcController#method(args)";

        private RpcControllerArgumentResolver() {
        }

        public boolean supportsParameter(MethodParameter parameter) {
            if (parameter.getExecutable() instanceof Method) {
                return parameter.getDeclaringClass().isAnnotationPresent(RpcController.class);
            }
            return false;
        }

        public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws IOException {
            Object[] arguments;
            Method method = Objects.requireNonNull(parameter.getMethod());
            HttpServletRequest httpServletRequest = (HttpServletRequest)Objects.requireNonNull(webRequest.getNativeRequest(HttpServletRequest.class));
            int parameterIndex = parameter.getParameterIndex();
            if (parameterIndex == 0) {
                arguments = RpcControllerArgumentResolver.parseMethodParameters(method, httpServletRequest);
                if (method.getParameterCount() > 1) {
                    httpServletRequest.setAttribute(CACHE_ATTRIBUTE_KEY, (Object)arguments);
                }
            } else {
                arguments = (Object[])httpServletRequest.getAttribute(CACHE_ATTRIBUTE_KEY);
            }
            return Collects.get(arguments, parameterIndex);
        }

        private static Object[] parseMethodParameters(Method method, HttpServletRequest request) throws IOException {
            if (QUERY_PARAM_METHODS.contains(request.getMethod())) {
                return RpcControllerUtils.parseQueryParameters(method, request.getParameterMap());
            }
            try (ServletInputStream inputStream = request.getInputStream();){
                String body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (StringUtils.isEmpty((CharSequence)body)) {
                    Object[] objectArray = RpcControllerUtils.parseQueryParameters(method, request.getParameterMap());
                    return objectArray;
                }
                Object[] objectArray = Jsons.parseMethodArgs(body, method);
                return objectArray;
            }
        }
    }
}

